﻿defClass(happyfarm.util, "Job", null, function(Job, Job_prototype){
    Job_prototype.init = function(){
        this.request = new happyfarm.util.Request();
        this.appLoader = new happyfarm.util.AppLoader();
        this.tools = new happyfarm.util.Tools();
    };
    
    Job_prototype.loadFarmland = function(userIndexId){
        var me = this;
        try {
            //获取农场信息
            if (userArray[userIndexId].check) {
                var url = "";
                if (userArray[userIndexId].uin) {
                    host = "http://nc.qzone.qq.com/cgi-bin/"
                } else {
                    host = "http://nc.xiaoyou.qq.com/cgi-bin/"
                }
                var sendTime = me.tools.getLocalTime();
				var uId = null;
				var uin = null;
				var flag = null;
				if(myId == userArray[userIndexId].uId){
					flag = "1";
				}else{
					uId = userArray[userIndexId].uId;
					uin = userArray[userIndexId].uin;
				}
                this.request.doGetRequest("cgi_farm_index?", "user", "run", "1", uId, uin, function(result){
                    if (result.status == 200) {
                        //获取本地时间
                        var localTime = sendTime;
                        result = eval('(' + result.responseText + ')');
                        if (result.errorType) {
                            if (result.errorType == "validateCode") {
                                document.getElementById("validate").style.visibility = "visible";
                                document.getElementById("verifycode").value = "";
                                document.getElementById("verifycode").focus();
                                document.getElementById("validateImg").src = "http://ptlogin2.qq.com/getimage?aid=353&" + Math.random();
                                if (document.getElementById("alertSound").checked) {
                                    if (navigator.userAgent.indexOf("Firefox") > 0) {
                                        try {
                                            document.getElementById('sound_ff').Play();
                                        } catch (e) {
                                        }
                                        alert("请输入验证码！");
                                    } else {
                                        document.getElementById('sound_ie').src = document.getElementById('alertSysSound').value;
                                    }
                                }
                                doValidate = function(){
                                    validateCode = document.getElementById("verifycode").value;
                                    document.getElementById("validate").style.visibility = "hidden";
                                    document.getElementById('sound_ie').src = '';
                                    if (navigator.userAgent.indexOf("Firefox") > 0) {
                                        try {
                                            document.getElementById('sound_ff').Stop();
                                        } catch (e) {
                                        }
                                    }
                                    
                                    //重新读取农场信息
                                    me.request.doGetRequest("cgi_farm_index?", "user", "run", 1, uId, uin, null);
                                    validate = true;
									
                                    //递归循环
                                    me.loadFarmland(userIndexId);
                                };
                                return;
                            }
                        }
                        //获取服务器时间
                        var serverTime = 0;
                        if (result.user) {
                            serverTime = result.user.healthMode.serverTime;
                        }
                        //读取好友农场信息
                        me.farmlandStatus(result, localTime, serverTime, userIndexId);
                        //更新进度条
                        userIndexId = userIndexId + 1;
                        me.appLoader.updateProgressBars(userIndexId, userArray.length);
                        //判断是否遍历完成
                        if (userIndexId == userArray.length) {
                            closeDialog("proDialog");
                            openDialog("detialDialog");
                            if (document.getElementById("farmDetail").checked || document.getElementById("harvestDetail").checked) {
                                window.setTimeout(function(){
                                    me.appLoader.creatDetails();
                                    me.appLoader.runMission();
                                    closeDialog("detialDialog");
                                }, 0);
                            } else {
                                window.setTimeout(function(){
                                    me.appLoader.runMission();
                                    closeDialog("detialDialog");
                                }, 0);
                            }
                        } else {
                            //递归循环
                            if (window.intervalTimeCheck) {
                                window.setTimeout(function(){
                                    me.loadFarmland(userIndexId);
                                }, intervalTimeValue);
                            } else {
                                me.loadFarmland(userIndexId);
                            }
                        }
                    } else {
                        //递归循环
                        me.loadFarmland(userIndexId);
                    }
                });
            } else {
                //更新进度条
                userIndexId = userIndexId + 1;
                me.appLoader.updateProgressBars(userIndexId, userArray.length);
                if (userIndexId == userArray.length) {
                    closeDialog("proDialog");
                    openDialog("detialDialog");
                    if (document.getElementById("farmDetail").checked || document.getElementById("harvestDetail").checked) {
                        window.setTimeout(function(){
                            me.appLoader.creatDetails();
                            me.appLoader.runMission();
                            closeDialog("detialDialog");
                        }, 0);
                    } else {
                        window.setTimeout(function(){
                            me.appLoader.runMission();
                            closeDialog("detialDialog");
                        }, 0);
                    }
                } else {
                    //递归循环
                    me.loadFarmland(userIndexId);
                }
            }
        } catch (error) {
        
        }
    };
    
    //获得农场信息，并生成相关的HTML代码
    Job_prototype.farmlandStatus = function(result, localTime, serverTime, userIndexId){
        //初始化一个好友的农场
        userArray[userIndexId]["indexId"] = userIndexId;
        userArray[userIndexId]["farmlandStatus"] = [];
        
        if (!result.farmlandStatus) {
            return;
        }
        //显示农场是否有狗
        if (result.dog) {
            //判断狗是否是饥饿状态(当狗还有1小时饥饿时就喂狗)
            if (result.dog.isHungry) {
                //添加有狗粮属性
                userArray[userIndexId]["dog"] = true;
                //判断是否是自己的狗
                if (myId == userArray[userIndexId].uId) {
                    if (document.getElementById("Auto-feed").checked) {
                        //喂狗
                        this.feedDog();
                    }
                }
            }
        } else {
            userArray[userIndexId]["dog"] = false;
        }
        
        //初始化统计变量
        userArray[userIndexId]["expCount"] = 0;
        userArray[userIndexId]["glodCount"] = 0;
        //开始遍历农场信息
        for (var i = 0; i < result.farmlandStatus.length; i++) {
            //初始化一个好友的一个农田
            userArray[userIndexId]["farmlandStatus"][i] = [];
            //初始化统计变量
            userArray[userIndexId]["farmlandStatus"][i]["weedsCount"] = 0;
            userArray[userIndexId]["farmlandStatus"][i]["borersCount"] = 0;
            userArray[userIndexId]["farmlandStatus"][i]["dryLand"] = false;
            userArray[userIndexId]["farmlandStatus"][i]["cropCount"] = 0;
            //初始化状态变量
            userArray[userIndexId]["farmlandStatus"][i]["landStatus"] = "";
            userArray[userIndexId]["farmlandStatus"][i]["cropStatus"] = -1;
            userArray[userIndexId]["farmlandStatus"][i]["time"] = 0;
            
            this.appLoader.updateProgressBar(i + 1, result.farmlandStatus.length);
            
            //获得农作物的ID
            var cId = result.farmlandStatus[i].a;
            
            //获取农作物的信息
            var crops = this.getCropsInfo(cId);
            
            //首先判断地里是否有农作物
            if (crops != null) {
                //农作物是否长杂草
                var weedsNum = result.farmlandStatus[i].f;
                //农作物是否生虫子
                var borersNum = result.farmlandStatus[i].g;
                //农作物是否干旱
                var dryland = result.farmlandStatus[i].h;
                //农作物成熟时间=农作物种植时间 + 成长时间 - 现在服务器时间
                var time = parseInt(result.farmlandStatus[i].q) + parseInt(crops.growthCycle) - parseInt(serverTime);
                
                //健康模式开启
                if (result.user.healthMode.set == 1) {
                    var matureTime = parseInt(result.farmlandStatus[i].q) + parseInt(crops.growthCycle);
                    matureTime = new Date(matureTime * 1000);
                    matureTime = matureTime.getHours();
                    //剔除健康模式期间成熟的作物
                    if (matureTime >= 0 && matureTime < 6) {
                        continue;
                    }
                }
                //添加作物名称
                userArray[userIndexId]["farmlandStatus"][i]["landStatus"] = crops.cName;
                
                //是否有虫
                if (borersNum > 0) {
                    if (window.borers_run) {
                        //清除虫子
                        for (var n = 0; n < borersNum; n++) {
                            this.clearBorers(userArray[userIndexId].uId, i, userIndexId, userArray[userIndexId].uin);
                        }
                    }
                }
                
                //是否有草
                if (weedsNum > 0) {
                    if (window.weeds_run) {
                        //清除杂草
                        for (var n = 0; n < weedsNum; n++) {
                            this.clearWeeds(userArray[userIndexId].uId, i, userIndexId, userArray[userIndexId].uin);
                        }
                    }
                }
                
                //是否干旱
                if (dryland == 0) {
                    if (window.dryland_run) {
                        //灌溉旱地
                        this.irrigation(userArray[userIndexId].uId, i, userIndexId, userArray[userIndexId].uin);
                    }
                }
                
                //收获果实
                //判断果实是否成熟
                if (result.farmlandStatus[i].q == 0) {
                    //判断是否是自己的地
                    if (myId == userArray[userIndexId].uId) {
                        //是否启用自动种菜功能
                        if (window.auto_crops_run) {
                            //锄地
                            this.hoeing(userArray[userIndexId].uId, i, userIndexId, userArray[userIndexId].uin);
                            //耕种
                            this.doFarming(userArray[userIndexId], i, userIndexId, userArray[userIndexId].uin);
                        }
                    } else {
                        //该地里面的果实已经收光了
                        userArray[userIndexId]["farmlandStatus"][i]["landStatus"] = "荒地";
                    }
                } else if (time <= 3600) {
                    //判断是否是自己的地，是否启用防偷盗系统
                    if (myId == userArray[userIndexId].uId && document.getElementById("Anti-theft").checked) {
                        if (time > 0) {
                            //如果自己本身没有化肥
                            if (fertilizerNum == 0) {
                                //购买化肥
                                this.buyFertilizer();
                            }
                            //施肥
                            this.fertilization(userArray[userIndexId].uId, i);
                            time = time - 3600;
                        }
                    }
                    //判断是否成熟
                    if (time <= 0) {
                        //判断是否是自己的地
                        if (myId == userArray[userIndexId].uId) {
                            //收获果实
                            this.getCrops(userArray[userIndexId].uId, i, 1, userIndexId, userArray[userIndexId].uin);
                            userArray[userIndexId]["farmlandStatus"][i]["cropStatus"] = 0;
                            //是否启用自动种菜功能
                            if (window.auto_crops_run) {
                                for (var c = 0; c < cropsInfo.length; c++) {
                                    //从种子列表中找到当前的种子信息
                                    if (cId == cropsInfo[c].cId) {
                                        //当前农作物所处的种植季判断，以便来区分是否可以锄地
                                        if (result.farmlandStatus[i].j == parseInt(cropsInfo[c].maturingTime) - 1) {
                                            //锄地
                                            this.hoeing(userArray[userIndexId].uId, i, userIndexId, userArray[userIndexId].uin);
                                            //耕种
                                            this.doFarming(userArray[userIndexId], i, userIndexId, userArray[userIndexId].uin);
                                        }
                                        break;
                                    }
                                }
                            }
                        } else {
                            //判断是否偷过
                            var stole = true;
                            var rogueList = result.farmlandStatus[i].n;
                            for (var farmlandOwner in rogueList) {
                                if (farmlandOwner == myId) {
                                    userArray[userIndexId]["farmlandStatus"][i]["cropStatus"] = 4;
                                    stole = false;
                                    break;
                                }
                            }
                            if (stole) {
                                //判断可以偷
                                if (result.farmlandStatus[i].l != result.farmlandStatus[i].m) {
                                    //有狗也可以偷
                                    if (window.dog_run || !result.dog || result.dog.isHungry) {
                                        if (window.crope_run) {
                                            //开始偷盗他人果实
                                            this.getCrops(userArray[userIndexId].uId, i, 0, userIndexId, userArray[userIndexId].uin);
                                            userArray[userIndexId]["farmlandStatus"][i]["cropStatus"] = 0;
                                        } else {
                                            userArray[userIndexId]["farmlandStatus"][i]["cropStatus"] = 1;
                                        }
                                    } else {
                                        userArray[userIndexId]["farmlandStatus"][i]["cropStatus"] = 2;
                                    }
                                } else {
                                    userArray[userIndexId]["farmlandStatus"][i]["cropStatus"] = 3;
                                }
                            }
                        }
                    }
                } else if (time > 3600) {
                    //各个阶段自动施肥
                    var n = i;
                    if (myId == userArray[userIndexId].uId && document.getElementById("Auto-fertilizer").checked) {
                        this.tools.getConfig("ini.xml", function(xmlDoc){
                            var crop = xmlDoc.getElementsByTagName("crop");
                            for (var i = 0; i < crop.length; i++) {
                                if (cId == crop[i].getAttribute("id")) {
                                    var cTime = crop[i].getAttribute("value");
                                    cTime = cTime.split(",");
                                    if (time > parseInt(cTime[cTime.length - 1]) - parseInt(cTime[cTime.length - 2])) {
                                        var job = new happyfarm.util.Job();
                                        //如果自己本身没有化肥
                                        if (fertilizerNum == 0) {
                                            //购买化肥
                                            job.buyFertilizer();
                                        }
                                        //施肥
                                        job.fertilization(userArray[userIndexId].uId, n);
                                        break;
                                    }
                                }
                            }
                        });
                    }
                }
                //如果没有选择有狗也偷，而此农场有狗，则不把农场的农作物的成熟时间做最短时间进行判断
                if (window.crope_run || myId == userArray[userIndexId].uId) {
                    if (window.dog_run || !result.dog || result.dog.isHungry || myId == userArray[userIndexId].uId) {
                        var theft = false;
                        if (window.dog_run && result.dog && !result.dog.isHungry && myId != userArray[userIndexId].uId) {
                            if (cId != window.dogCrops1_id && cId != window.dogCrops2_id && cId != window.dogCrops3_id) {
                                theft = true;
                            }
                        } else {
                            theft = true;
                        }
                        if (time > 0) {
                            if (theft) {
                                //是否选择了偷取该作物
                                for (var j = 0; j < cropsInfo.length; j++) {
                                    if (cropsInfo[j].cId == cId && cropsInfo[j].check) {
                                        var target = {};
                                        target["time"] = time;
                                        target["owner"] = userArray[userIndexId];
                                        target["farm"] = result.farmlandStatus[i];
                                        target["farm"]["cName"] = crops.cName;
                                        //取得该作物的种植季
                                        target["farm"]["harvestTimes"] = cropsInfo[j].maturingTime;
                                        target["farmIndex"] = i;
                                        target["localTime"] = localTime;
                                        target["serverTime"] = serverTime;
                                        if (result.dog && !result.dog.isHungry) {
                                            target["dogIsHungry"] = true
                                        } else {
                                            target["dogIsHungry"] = false;
                                        }
										target["run"] = true;
                                        targetMission.push(target);
                                        break;
                                    }
                                }
                            }
                            //生成倒计时
                            userArray[userIndexId]["farmlandStatus"][i]["time"] = this.tools.culTime(time);
                        }
                    } else {
                        userArray[userIndexId]["farmlandStatus"][i]["time"] = this.tools.culTime(time);
                    }
                }
            } else {
                //判断是否是自己的地
                if (myId == userArray[userIndexId].uId) {
                    //是否启用自动种菜功能
                    if (window.auto_crops_run) {
                        //耕种
                        this.doFarming(userArray[userIndexId], i, userIndexId, userArray[userIndexId].uin);
                    }
                } else {
                    //该地里面的是空地
                    userArray[userIndexId]["farmlandStatus"][i]["landStatus"] = "空地";
                }
            }
        }
    };
    
    //独立维护一块地,为即时偷果子服务
    Job_prototype.onFarmRun = function(misId, owner, farm, farmIndex, retryTimes){
        var act, mode;
        var me = this;
        //判断是否是自己的地
        if (myId == owner.uId) {
            act = "harvest";
            mode = "cgi_farm_plant?";
        } else {
            act = "scrounge";
            mode = "cgi_farm_steal?";
        }
        if (owner.uin != null) {
            host = "http://nc.qzone.qq.com/cgi-bin/";
        } else {
            host = "http://nc.xiaoyou.qq.com/cgi-bin/";
        }
        var postData = "ownerId=" + owner.uId + "&place=0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17";
        this.request.doPostRequest(postData, mode, "farmlandstatus", act, null, owner.uin, function(result){
            if (result.status == 200) {
                result = eval('(' + result.responseText + ')');
                if (result) {
                    if (result.errorType) {
                        if (result.errorType == "validateCode") {
                            document.getElementById("cropsState_" + owner.uId + "_" + farmIndex).innerHTML = "忽略";
                            //失败原因
                            document.getElementById("cropsDirection_" + owner.uId + "_" + farmIndex).innerHTML = "等待输入验证码";
                            if (validate) {
                                validate = false;
                                
                                document.getElementById("validate").style.visibility = "visible";
                                document.getElementById('verifycode').value = "";
                                document.getElementById('verifycode').focus();
                                document.getElementById("validateImg").src = "http://ptlogin2.qq.com/getimage?aid=353&" + Math.random();
                                if (document.getElementById("alertSound").checked) {
                                    if (navigator.userAgent.indexOf("Firefox") > 0) {
                                        try {
                                            document.getElementById('sound_ff').Play();
                                        } catch (e) {
                                        }
                                        alert("请输入验证码！");
                                    } else {
                                        document.getElementById('sound_ie').src = document.getElementById('alertSysSound').value;
                                    }
                                }
                                doValidate = function(){
                                    validateCode = document.getElementById("verifycode").value;
                                    document.getElementById("validate").style.visibility = "hidden";
                                    document.getElementById('sound_ie').src = '';
                                    if (navigator.userAgent.indexOf("Firefox") > 0) {
                                        try {
                                            document.getElementById('sound_ff').Stop();
                                        } catch (e) {
                                        }
                                    }
                                    //重新读取农场信息
                                    me.request.doGetRequest("cgi_farm_index?", "user", "run", 1, owner.uId, owner.uin, null);
                                    validate = true;
                                };
                            }
                        }
                    } else if(result.code == 0){
						me.request.doGetRequest("cgi_farm_index?", "user", "run", 1, owner.uId, owner.uin, null);
						//请求回复会出现错误，原因不明，遇到此问题自动重试
						if(targetMission[misId]["run"]){
							if (retryTimes < retry) {
								retryTimes = retryTimes + 1;
								document.getElementById("cropsState_" + owner.uId + "_" + farmIndex).innerHTML = "重试" + retryTimes + "次";
								//延迟重试
								window.setTimeout(function(){
									me.onFarmRun(misId, owner, farm, farmIndex, retryTimes);
								}, retryTime);
							} else {
								document.getElementById("cropsState_" + owner.uId + "_" + farmIndex).innerHTML = "失败";
								//失败原因
								document.getElementById("cropsDirection_" + owner.uId + "_" + farmIndex).innerHTML = result.direction;
							}
						}
					} else {
						//循环遍历全部菜地结果信息
						for(var i = 0;i<result.length;i++){
							//失败
							if (result[i].code == 0 || result[i].harvest == 0) {
								//判断是否是当前菜地
								if(i == farmIndex){
									//判断是否被狗咬
									if(result[i].direction.indexOf("狗") > 0){
										//更新任务状态
										document.getElementById("cropsState_" + owner.uId + "_" + i).innerHTML = "失败";
										//失败原因
										document.getElementById("cropsDirection_" + owner.uId + "_" + i).innerHTML = result[i].direction;
										continue;
									}
									//判断是否处于健康保护模式
									if(result[i].direction == "decode error"){
										document.getElementById("cropsState_" + owner.uId + "_" + farmIndex).innerHTML = "失败";
										//失败原因
										document.getElementById("cropsDirection_" + owner.uId + "_" + farmIndex).innerHTML = "健康保护模式";
										return;
									}
									
									if(targetMission[misId]["run"]){
										if (retryTimes < retry) {
											retryTimes = retryTimes + 1;
											document.getElementById("cropsState_" + owner.uId + "_" + farmIndex).innerHTML = "重试" + retryTimes + "次";
											//延迟重试
											window.setTimeout(function(){
												me.onFarmRun(misId, owner, farm, farmIndex, retryTimes);
											}, retryTime);
										} else {
											document.getElementById("cropsState_" + owner.uId + "_" + farmIndex).innerHTML = "失败";
											//失败原因
											document.getElementById("cropsDirection_" + owner.uId + "_" + farmIndex).innerHTML = "没有偷到果实";
										}
									}else{
										//此段代码以防万一，理论上不需要，被执行的几率很低。
										if(document.getElementById("cropsCount_" + owner.uId + "_" + i).innerHTML > 0){
											document.getElementById("cropsState_" + owner.uId + "_" + farmIndex).innerHTML = "成功";
										}else{
											document.getElementById("cropsState_" + owner.uId + "_" + farmIndex).innerHTML = "失败";
										}
									}
								}
							} else {
								//成功
								if (owner.uId == myId) {
									if (parseInt(result[i].harvest) > 0) {
										//是否启用自动种菜功能和丰收后立即种菜
										if (window.auto_crops_run && window.auto_farm_run) {
											for (var c = 0; c < cropsInfo.length; c++) {
												//从种子列表中找到当前的种子信息
												if (farm.a == cropsInfo[c].cId) {
													//当前农作物所处的种植季判断，以便来区分是否可以锄地
													if (farm.j == parseInt(cropsInfo[c].maturingTime) - 1) {
														//锄地
														me.hoeing(owner.uId, i, owner.indexId, owner.uin);
														//耕种
														me.doFarming(owner, i, owner.uin);
													}
													break;
												}
											}
										}
									}
								} 
																	
								//更新任务状态
								document.getElementById("cropsState_" + owner.uId + "_" + i).innerHTML = "成功";
								document.getElementById("cropsDirection_" + owner.uId + "_" + i).innerHTML = "";
								//更新单个数量
								document.getElementById("cropsCount_" + owner.uId + "_" + i).innerHTML = result[i].harvest;
								//生成的即时信息合计
								document.getElementById("cropSum").innerHTML = parseInt(document.getElementById("cropSum").innerHTML) + result[i].harvest;
																
								//标记已完成任务
								targetMission[misId]["run"] = false;
							}
						}
                    }  
                }
            } else {
                if (retryTimes < retry) {
                    retryTimes = retryTimes + 1;
                    document.getElementById("cropsState_" + owner.uId + "_" + farmIndex).innerHTML = "重试" + retryTimes + "次";
                    //延迟0.01秒重试
                    window.setTimeout(function(){
                        me.onFarmRun(misId, owner, farm, farmIndex, retryTimes);
                    }, retryTime);
                } else {
                    document.getElementById("cropsState_" + owner.uId + "_" + farmIndex).innerHTML = "失败";
                    //失败原因
                    document.getElementById("cropsDirection_" + owner.uId + "_" + farmIndex).innerHTML = "网络访问超时";
                }
            }
        });
    };
    
    //获取实时目标信息
    Job_prototype.getOutput = function(target){
        var url = "";
        var postData = "ownerId=" + target.owner.uId + "&place=" + target.farmIndex;
        if (target.owner.uin != null) {
            url = "http://happyfarm.qzone.qq.com/api.php?";
        } else {
            url = "http://happyfarm.xiaoyou.qq.com/api.php?";
        }
        this.request.doPostCommon(postData, url, "farmlandstatus", "getOutput");
        this.onFarmRun(target.owner, target.farm, target.farmIndex, 0);
    };
    
    //获得好友列表
    Job_prototype.getUserList = function(onUser){
		
        var result, result_qzone, result_xiaoyou;
        var postData = "refresh=true&user=true";
        if (document.getElementById("host1").checked || document.getElementById("host3").checked) {
            result_qzone = this.request.doPostRequest(postData, "cgi_farm_getFriendList?", "friend");
			if (navigator.userAgent.indexOf("MSIE") > 0) {
				document.getElementById("test").innerHTML = result_qzone.responseText;
				result_qzone = document.getElementById("test").innerHTML;
				result_qzone = result_qzone.replace(/�,/g,"\",");
				result_qzone = result_qzone.replace(/�\"/g,"\",\"");
				result_qzone = result_qzone.replace(/:\"\",/g,":\" \",");
				result_qzone = result_qzone.replace(/\"\"/g,"\"");
				result_qzone = eval('(' + result_qzone + ')') ;
			} else if (navigator.userAgent.indexOf("Firefox") > 0) {
				result_qzone = eval('(' + result_qzone.responseText + ')') ;
			}
            result = result_qzone;
        }
		if (document.getElementById("host2").checked || document.getElementById("host3").checked) {
            result_xiaoyou = this.request.doPostRequest(postData, "cgi_farm_getFriendList?", "friend");
            result_xiaoyou = result_xiaoyou.responseText;
			result_xiaoyou = eval('(' + result_xiaoyou + ')') ;
            result = result_xiaoyou;
        }
        if (result == null || result.errorType == "validateCode") {
            return result;
        }
        
        if (document.getElementById("host3").checked) {
            result = result_xiaoyou.concat(result_qzone);
        }
        
        //按照userId降序
        result.sort(function(a, b){
            return parseInt(a["userId"]) > parseInt(b["userId"]) ? -1 : 1
        });
        
        //增加登录人信息
        //43157842
        var userFlag = true;
        //当选择双开的时候，剔除重复好友
        var uId = "";
        for (var i = 0; i < result.length; i++) {
            if (result[i].uId == myId) {
                userFlag = false;
            }
            //当选择双开的时候，剔除重复好友
            if (result[i].uId == uId) {
                result.splice(i, 1);
                i = i - 1;
            } else {
                uId = result[i].uId;
            }
        }
        if (userFlag) {
            var uin = "";
            if (document.getElementById("host1").checked) {
                uin = "43157842";
            }
            result.push({
                "uId": myId,
                "userName": onUser.user.userName,
                "headPic": onUser.user.headPic,
                "exp": onUser.user.exp,
                "money": onUser.user.money,
                "uin": uin
            });
        }
        
        //排序判断
        if (document.getElementById("sort1").checked == true) {
            //按照经验降序
            result.sort(function(a, b){
                return parseInt(a["exp"]) > parseInt(b["exp"]) ? -1 : 1
            });
        } else if (document.getElementById("sort2").checked == true) {
            //按照金币降序
            result.sort(function(a, b){
                return parseInt(a["money"]) > parseInt(b["money"]) ? -1 : 1
            });
        }
		
        return result;
    };
    
    //获取农作物的信息
    Job_prototype.getCropsInfo = function(cId){
        var crops = null;
        for (var i = 0; i < cropsInfo.length; i++) {
            if (cropsInfo[i].cId == cId) {
                crops = cropsInfo[i];
                break;
            }
        }
        return crops;
    };
    
    //生成个人信息
    Job_prototype.getUserInfo = function(){
        try {
			var postData = "ownerId=0";
            //var result = this.request.doPostCommon(null, "http://happyfarm.qzone.qq.com/api.php?", "user", "run");
			var result = this.request.doPostRequest(postData, "cgi_farm_index?", "user", "run", 1);
            result = eval('(' + result.responseText + ')');
			//校验FarmKey失败, 重试
			while(result.direction && result.direction=="校验FarmKey失败"){
				result = this.getUserInfo();
			}
			myId = result.user.uId;
			uinLogin = result.user.uinLogin;
            return result;
        } catch (e) {
        
        }
    };
    
    //收获果实
    Job_prototype.getCrops = function(ownerId, farmlandIndex, mine, userIndexId, uinX){
        var postData = "ownerId=" + ownerId + "&place=" + farmlandIndex;
        var result;
        //判断是否是自己的地，0：不是	1：是
        try {
            if (mine == 0) {
                result = this.request.doPostRequest(postData, "cgi_farm_steal?", "farmlandstatus", "scrounge", null, uinX);
            } else {
                result = this.request.doPostRequest(postData, "cgi_farm_plant?", "farmlandstatus", "harvest");
            }
            result = eval('(' + result.responseText + ')');
            if (result) {
                if (result.code == 1) {
                    //如果是自己的果实可获得经验
                    if (mine == 1) {
                        if (result.exp) {
                            userArray[userIndexId]["expCount"] = parseInt(userArray[userIndexId]["expCount"]) + parseInt(result.exp);
                        }
                    }
                    //获得实际收获果实数量
                    if (result.harvest) {
                        userArray[userIndexId]["farmlandStatus"][farmlandIndex]["cropCount"] = parseInt(result.harvest);
                    }
                }
            }
        } catch (e) {
            //
        }
    };
    
    //商店信息
    Job_prototype.getSeedInfo = function(){
        try {
            //var result = this.request.doPostCommon(null, "http://happyfarm.qzone.qq.com/api.php?", "repertory", "getSeedInfo");
			var result = this.request.doPostCommon(null, "http://farm.qzone.qq.com/cgi-bin/cgi_farm_getseedinfo?", "repertory", "getSeedInfo");
            result = eval('(' + result + ')');
			if(result.errorType){
				return result;
			}
            result.push({
                "cId": 46,
                "cName": "爱心果",
                "cType": 1,
                "growthCycle": 111600,
                "maturingTime": 3,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 101,
                "cName": "薰衣草",
                "cType": 1,
                "growthCycle": 219600,
                "maturingTime": 3,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 102,
                "cName": "马蹄莲",
                "cType": 1,
                "growthCycle": 230400,
                "maturingTime": 3,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 103,
                "cName": "天香百合",
                "cType": 1,
                "growthCycle": 72000,
                "maturingTime": 1,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 104,
                "cName": "非洲菊",
                "cType": 1,
                "growthCycle": 75600,
                "maturingTime": 2,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 105,
                "cName": "小雏菊",
                "cType": 1,
                "growthCycle": 61200,
                "maturingTime": 1,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 56,
                "cName": "哈密瓜",
                "cType": 1,
                "growthCycle": 111600,
                "maturingTime": 5,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 64,
                "cName": "大葱",
                "cType": 1,
                "growthCycle": 39600,
                "maturingTime": 1,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 66,
                "cName": "鲜姜",
                "cType": 1,
                "growthCycle": 39600,
                "maturingTime": 1,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 71,
                "cName": "小白菜",
                "cType": 1,
                "growthCycle": 39600,
                "maturingTime": 1,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 73,
                "cName": "菠菜",
                "cType": 1,
                "growthCycle": 61200,
                "maturingTime": 1,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 70,
                "cName": "黄豆",
                "cType": 1,
                "growthCycle": 100800,
                "maturingTime": 2,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 69,
                "cName": "莴笋",
                "cType": 1,
                "growthCycle": 198000,
                "maturingTime": 4,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 67,
                "cName": "香瓜",
                "cType": 1,
                "growthCycle": 277200,
                "maturingTime": 4,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 80,
                "cName": "月柿",
                "cType": 1,
                "growthCycle": 111600,
                "maturingTime": 5,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 75,
                "cName": "桑葚",
                "cType": 1,
                "growthCycle": 111600,
                "maturingTime": 5,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 120,
                "cName": "蒲公英",
                "cType": 1,
                "growthCycle": 57600,
                "maturingTime": 1,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 110,
                "cName": "满天星",
                "cType": 1,
                "growthCycle": 79200,
                "maturingTime": 1,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 111,
                "cName": "粉玫瑰",
                "cType": 1,
                "growthCycle": 100800,
                "maturingTime": 2,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
             result.push({
                "cId": 122,
                "cName": "丁香花",
                "cType": 1,
                "growthCycle": 111600,
                "maturingTime": 2,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 112,
                "cName": "风信子",
                "cType": 1,
                "growthCycle": 111600,
                "maturingTime": 2,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 118,
                "cName": "水仙花",
                "cType": 1,
                "growthCycle": 111600,
                "maturingTime": 2,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 113,
                "cName": "枙子花",
                "cType": 1,
                "growthCycle": 133200,
                "maturingTime": 3,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 106,
                "cName": "郁金香",
                "cType": 1,
                "growthCycle": 187200,
                "maturingTime": 3,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 109,
                "cName": "蝴蝶兰",
                "cType": 1,
                "growthCycle": 230400,
                "maturingTime": 3,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 114,
                "cName": "蓝玫瑰",
                "cType": 1,
                "growthCycle": 151200,
                "maturingTime": 4,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 107,
                "cName": "仙人掌",
                "cType": 1,
                "growthCycle": 115200,
                "maturingTime": 4,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 115,
                "cName": "兰花",
                "cType": 1,
                "growthCycle": 151200,
                "maturingTime": 4,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
             result.push({
                "cId": 108,
                "cName": "铃兰",
                "cType": 1,
                "growthCycle": 115200,
                "maturingTime": 4,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 123,
                "cName": "海棠花",
                "cType": 1,
                "growthCycle": 277200,
                "maturingTime": 4,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 62,
                "cName": "四叶草",
                "cType": 1,
                "growthCycle": 82800,
                "maturingTime": 2,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 81,
                "cName": "圣诞树",
                "cType": 1,
                "growthCycle": 46800,
                "maturingTime": 1,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 43,
                "cName": "无花果",
                "cType": 1,
                "growthCycle": 151200,
                "maturingTime": 3,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 52,
                "cName": "金针菇",
                "cType": 1,
                "growthCycle": 151200,
                "maturingTime": 4,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 91,
                "cName": "山楂",
                "cType": 1,
                "growthCycle": 79200,
                "maturingTime": 1,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 82,
                "cName": "摇钱树",
                "cType": 1,
                "growthCycle": 133200,
                "maturingTime": 3,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 92,
                "cName": "稀世琉璃果",
                "cType": 1,
                "growthCycle": 165600,
                "maturingTime": 4,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 121,
                "cName": "蔷薇",
                "cType": 1,
                "growthCycle": 165600,
                "maturingTime": 3,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 124,
                "cName": "月季花",
                "cType": 1,
                "growthCycle": 115200,
                "maturingTime": 4,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 125,
                "cName": "太阳花",
                "cType": 1,
                "growthCycle": 111600,
                "maturingTime": 5,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 116,
                "cName": "曼陀罗华",
                "cType": 1,
                "growthCycle": 111600,
                "maturingTime": 5,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 117,
                "cName": "康乃馨",
                "cType": 1,
                "growthCycle": 111600,
                "maturingTime": 5,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
            result.push({
                "cId": 119,
                "cName": "紫罗兰",
                "cType": 1,
                "growthCycle": 111600,
                "maturingTime": 5,
                "expect": 0,
                "output": 0,
                "sale": 0,
                "price": 0,
                "cLevel": 0,
                "cropExp": 0,
                "vip": null
            });
			
			//按照cId升序
            result.sort(function(a, b){
                return parseInt(a["cId"]) < parseInt(b["cId"]) ? -1 : 1
            });
			
            return result;
        } catch (e) {
        
        }
    };
    
    //背包信息
    Job_prototype.getUserSeed = function(){
        try {
            var result = this.request.doPostCommon(null, "http://farm.qzone.qq.com/cgi-bin/cgi_farm_getuserseed?", "repertory", "getUserSeed");
            result = eval('(' + result + ')');
            return result;
        } catch (e) {
        
        }
    };
	
	//生成用户农田图例
	Job_prototype.createUserFarm = function(i, farms, myFarm){
		var text = "";
		var farm = document.createElement("div");
		farm.className = "farm";
		
		var farmTitle = document.createElement("div");
		farmTitle.id = "farmTitle" + i;
		farmTitle.className = "farmTitle";
		if(farms.bitmap == "1"){
			text = document.createTextNode("第" + (i+1) + "块农田(红)");
		}else{
			text = document.createTextNode("第" + (i+1) + "块农田");
		}
		farmTitle.appendChild(text);
		farmTitle.onclick = function(){
			selectFarm = i;	
			for(var j=0;j<farmArray.length;j++){
				document.getElementById("farmTitle" + j).parentNode.className = "farm";
			}
			farmTitle.parentNode.className = "farmSelect";
		}
		
		var farmContent = document.createElement("div");
		farmContent.id = "farmContent" + i;
		
		//读取文件中的记录
		for(var j=0;j<farmRecords.length;j++){
			this.createFarmSeed(i, j, farmContent);
		}
		
		farm.appendChild(farmTitle);
		farm.appendChild(farmContent);
		myFarm.appendChild(farm);
    };
	
	//生成用户农田图例
	Job_prototype.createFarmSeed = function(i, j, farmContent){
		if(farmRecords[j].getAttribute("fId") == i){
			var farmSeed = document.createElement("div");
			farmSeed.id = farmRecords[j].getAttribute("cId");
			if(farmSeed.id>200 || farmSeed.id=="126"){
				farmSeed.className = "seedRed";
			}else{
				farmSeed.className = "seed";
			}
			farmSeed.style.width="100%";
			farmSeed.onclick = function(){
				farmSeed.parentNode.removeChild(farmSeed);
			}
			farmSeed.appendChild(document.createTextNode(farmRecords[j].getAttribute("cName")));
			farmContent.appendChild(farmSeed);
		}
	}
    
    //仓库信息
    Job_prototype.getUserCrop = function(){
        try {
            var result = this.request.doPostCommon(null, "http://nc.qzone.qq.com/cgi-bin/cgi_farm_getusercrop?", "repertory", "getUserCrop");
            result = eval('(' + result + ')');
            return result;
        } catch (e) {
        
        }
    };
    
    //清除杂草
    Job_prototype.clearWeeds = function(ownerId, farmlandIndex, userIndexId, uinX){
        postData = "ownerId=" + ownerId + "&place=" + farmlandIndex;
        try {
            var result = this.request.doPost(postData, "cgi_farm_opt?", "farmlandstatus", "clearWeed", null, uinX);
            result = eval('(' + result + ')');
            if (result) {
                if (result.code == 1) {
                    //经验满后，停止除草
                    if (document.getElementById("Auto-act").checked && parseInt(result.money) == 0 && parseInt(result.exp) == 0) {
                        document.getElementById("weeds").checked = false;
                    } else {
                        userArray[userIndexId]["farmlandStatus"][farmlandIndex]["weedsCount"] = parseInt(userArray[userIndexId]["farmlandStatus"][farmlandIndex]["weedsCount"]) + 1;
                        userArray[userIndexId]["goldCount"] = parseInt(userArray[userIndexId]["goldCount"]) + parseInt(result.money);
                        userArray[userIndexId]["expCount"] = parseInt(userArray[userIndexId]["expCount"]) + parseInt(result.exp);
                    }
                }
            }
        } catch (e) {
        
        }
    };
    
    //清除虫子
    Job_prototype.clearBorers = function(ownerId, farmlandIndex, userIndexId, uinX){
        postData = "ownerId=" + ownerId + "&place=" + farmlandIndex;
        try {
            var result = this.request.doPost(postData, "cgi_farm_opt?", "farmlandstatus", "spraying", null, uinX);
            result = eval('(' + result + ')');
            
            if (result) {
                if (result.code == 1) {
                    //经验满后，停止除虫
                    if (document.getElementById("Auto-act").checked && parseInt(result.money) == 0 && parseInt(result.exp) == 0) {
                        document.getElementById("borers").checked = false;
                    } else {
                        userArray[userIndexId]["farmlandStatus"][farmlandIndex]["borersCount"] = parseInt(userArray[userIndexId]["farmlandStatus"][farmlandIndex]["borersCount"]) + 1;
                        userArray[userIndexId]["goldCount"] = parseInt(userArray[userIndexId]["goldCount"]) + parseInt(result.money);
                        userArray[userIndexId]["expCount"] = parseInt(userArray[userIndexId]["expCount"]) + parseInt(result.exp);
                    }
                }
            }
        } catch (e) {
        
        }
    };
    
    //灌溉旱地
    Job_prototype.irrigation = function(ownerId, farmlandIndex, userIndexId, uinX){
        postData = "ownerId=" + ownerId + "&place=" + farmlandIndex;
        try {
            var result = this.request.doPost(postData, "cgi_farm_opt?", "farmlandstatus", "water", null, uinX);
            result = eval('(' + result + ')');
            
            if (result) {
                if (result.code == 1) {
                    //经验满后，停止灌溉
                    if (document.getElementById("Auto-act").checked && parseInt(result.money) == 0 && parseInt(result.exp) == 0) {
                        document.getElementById("dryland").checked = false;
                    } else {
                        userArray[userIndexId]["farmlandStatus"][farmlandIndex]["dryLand"] = true;
                        userArray[userIndexId]["goldCount"] = parseInt(userArray[userIndexId]["goldCount"]) + parseInt(result.money);
                        userArray[userIndexId]["expCount"] = parseInt(userArray[userIndexId]["expCount"]) + parseInt(result.exp);
                    }
                }
            }
        } catch (e) {
        
        }
    };
    
    
    //购买普通化肥
    Job_prototype.buyFertilizer = function(){
        postData = "number=1&tId=1&type=3";
        try {
            var result = this.request.doPost(postData, "cgi_farm_opt?", "usertool", "buyTool", null, null);
            result = eval('(' + result + ')');
            
            if (document.getElementById("Auto-saleAll").checked) {
                //金币不足时，变卖所有果实
                if (result.code == 0) {
                    this.saleAllCrops();
                    //再次购买普通化肥
                    result = this.request.doPost(postData, "cgi_farm_opt?", "usertool", "buyTool", null, null);
                }
            }
            
            if (result.code) {
                if (result.code == 1) {
                    fertilizerNum = fertilizerNum + 1;
                }
            }
        } catch (e) {
        
        }
    };
    
    //施普通化肥
    Job_prototype.fertilization = function(ownerId, farmlandIndex){
        postData = "ownerId=" + ownerId + "&place=" + farmlandIndex + "&tId=1";
        try {
            var result = this.request.doPost(postData, "cgi_farm_opt?", "farmlandstatus", "fertilize", null, uinX);
            result = eval('(' + result + ')');
            //当成功施肥后，减少一袋化肥
            if (result.code) {
                if (result.code == 1) {
                    fertilizerNum = fertilizerNum - 1;
                }
            }
        } catch (e) {
        
        }
    };
    
    //锄地
    Job_prototype.hoeing = function(ownerId, farmlandIndex, userIndexId, uinX){
        postData = "ownerId=" + ownerId + "&place=" + farmlandIndex;
        try {
            var result = this.request.doPost(postData, "cgi_farm_plant?", "farmlandstatus", "scarify", null, uinX);
            result = eval('(' + result + ')');
            if (result.exp && userIndexId) {
                userArray[userIndexId]["expCount"] = parseInt(userArray[userIndexId]["expCount"]) + parseInt(result.exp);
            }
            return result;
        } catch (e) {
        
        }
    };
    
    //购买种子
    Job_prototype.buySeeds = function(cId, num){
        if (!num) {
            num = 1;
        }
        var postData = "cId=" + cId + "&number=" + num;
        try {
            var result = this.request.doPostCommon(postData, "http://farm.qzone.qq.com/cgi-bin/cgi_farm_buyseed?", "repertory", "buySeed");
            result = eval('(' + result + ')');
            if (document.getElementById("Auto-saleAll").checked) {
                //金币不足时，变卖所有果实
                if (result.code != 1) {
                    this.saleAllCrops();
                    //再次购买种子
                    result = this.request.doPostCommon(postData, "http://farm.qzone.qq.com/cgi-bin/cgi_farm_buyseed?", "repertory", "buySeed");
                }
            }
        } catch (e) {
        
        }
    };
    
    //种地
    Job_prototype.farming = function(cId, ownerId, farmlandIndex, userIndexId, uinX){
        postData = "cId=" + cId + "&ownerId=" + ownerId + "&place=" + farmlandIndex;
        try {
            var result = this.request.doPost(postData, "cgi_farm_plant?", "farmlandstatus", "planting", null, uinX);
            result = eval('(' + result + ')');
            
            if (result.exp && userIndexId) {
                userArray[userIndexId]["expCount"] = parseInt(userArray[userIndexId]["expCount"]) + parseInt(result.exp);
            }
            return result;
        } catch (e) {
        
        }
    };
    
    //耕种
    Job_prototype.doFarming = function(owner, i, userIndexId, uinX){
        var userIndexId = owner.indexId;
        var defultCrop = null;
		var farmTitle = document.getElementById("farmTitle" + i).innerHTML;
		var farmContent = document.getElementById("farmContent" + i);
		if(farmTitle.indexOf("红")>0){
			defultCrop = document.getElementById("defult-red-crop").value;
		}else{
			defultCrop = document.getElementById("defult-crop").value;
		}
            
		var tmpCId = null;
        var cropsId = 0;
        var delflag = true;
			
        //准备先播种的种子
        if (document.getElementById("defult-crop-first").checked) {
            tmpCId = defultCrop;
        }else if (farmContent.childNodes.length > 0) {
			tmpCId = farmContent.firstChild.id;
		}else{
			tmpCId = defultCrop;
		}
            
		for (var j = 0; j < readyCrops.length; j++) {
            if (readyCrops[j][0] == tmpCId && readyCrops[j][2] == 1) {
                //如果是待购种子需要买种子，已购的不需要购买，直接种植
                cropsId = j;
                delflag = false;
                break;
            }
        }
        if (delflag) {
            this.buySeeds(tmpCId);
        }
            
        //种植农作物
        var result = this.farming(tmpCId, owner.uId, i, userIndexId, uinX);
        if (result) {
            if (result.code == 1) {
                //完成预先设定的种植作物后，在种子列表中删除这个种子
				if(cropsId != 0){
                   	this.appLoader.delReadyCrops(cropsId + 1);
				}
				if(farmContent.childNodes.length > 0 && tmpCId == farmContent.firstChild.id){
					farmContent.removeChild(farmContent.firstChild);
				}
            }
        }
    };
    
    //喂狗
    Job_prototype.feedDog = function(){
        try {
            var postData = "uId=" + myId;
            var result = this.request.doPostCommon(postData, "http://happyfarm.qzone.qq.com/api.php?", "dog", "feedDog");
            result = eval('(' + result + ')');
        } catch (e) {
        
        }
    };
    
    //变卖全部果实
    Job_prototype.saleAllCrops = function(){
        try {
            var postData = "uId=" + myId;
            var result = this.request.doPostCommon(postData, "http://happyfarm.qzone.qq.com/api.php?", "repertory", "saleAll");
            result = eval('(' + result + ')');
        } catch (e) {
        
        }
    };
});
