﻿// JavaScript Document

function openDialog(dialog){
    document.getElementById(dialog).style.visibility = "visible";
}

function closeDialog(dialog){
    document.getElementById(dialog).style.visibility = "hidden";
}

function showTabInit(){
    for (var i = 0; i < 8; i++) {
        document.getElementById("tabLayer" + i).style.display = "none";
        document.getElementById("tab" + i).className = "";
        document.getElementById("tabSpan" + i).className = "";
    }
}

function showTab(tab){
    showTabInit();
    document.getElementById("tabLayer" + tab).style.display = "";
    document.getElementById("tabLayer" + tab).style.width = "100%";
    document.getElementById("tab" + tab).className = "selectli";
    document.getElementById("tabSpan" + tab).className = "selectspan";
	/*
	if(tab == 4){
		if (document.getElementById("host1").checked) {
			document.getElementById("happyfarm").src = "http://happyfarm.qzone.qq.com/";
		} else {
			document.getElementById("happyfarm").src = "http://happyfarm.xiaoyou.qq.com/";
		}
	}
	*/
}

function submitVerifycode(e){
	var keynum = 0;
	if(window.event){
		keynum = e.keyCode;
	}else if(e.which){
		keynum = e.which;
	}
	if(keynum == 13){
		document.getElementById("validateButton").focus(); 
		document.getElementById("validateButton").click(); 
	}
}

	
function print(debugText){
   debug.innerHTML += debugText;
};

function println(debugText){
   debug.innerHTML += debugText + "<br/>";
};

window.happyfarm = {};
happyfarm.util = {};

var defClass = function(objNS, strName, objSuper, fctDef){
    var noInit = {};
    
    var c = objNS[strName] = function(){
        if (arguments[0] !== noInit) 
            this.init.apply(this, arguments);
    };
    
    if (objSuper) {
        c.prototype = new objSuper(noInit);
        
        c._super = function(fct, arrArgs){
            if (!arrArgs) 
                arrArgs = [];
            var sf = objSuper.prototype[fct];
            
            return sf.apply(this, arrArgs);
        };
    }
    
    fctDef(c, c.prototype);
};
	
function doValidate(){
}

function saveLoginConfig(){
	if(document.getElementById("u").value !="" && document.getElementById("p").value !="" && document.getElementById("verifycode").value !=""){//保存登录配置
		var tools = new happyfarm.util.Tools();
		var content = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + "\n";
		content += "<login>" + "\n";
		content += "<user userId=\"" + document.getElementById("u").value + "\" userPwd=\"" + document.getElementById("p").value + "\"/>" + "\n";
		content += "</login>";
		tools.saveConfig(content, "login", "root", false);
	}
}

//取得登录配置
function getLoginConfig(){
	var tools = new happyfarm.util.Tools();
    var fct = function(xmlDoc){
        var rs = xmlDoc.getElementsByTagName("user");
		if(rs.length > 0){
			document.getElementById("u").value = rs[0].getAttribute("userId");
			document.getElementById("p").value = rs[0].getAttribute("userPwd");
		}
    };
    tools.getConfig("login.config", fct);
}

function $(obj){
	return document.getElementById(obj);
}

function initialization(){
	//debug
	debug = document.getElementById("debug");
	
	// firefox,打开跨域访问权限
    if (navigator.userAgent.indexOf("Firefox") > 0) {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
    }
	if(host == ""){
		if (document.getElementById("host1").checked) {
			host = document.getElementById("host1").value;
		} else {
			host = document.getElementById("host2").value;
		}
	}
    var request = new happyfarm.util.Request();
    var tools = new happyfarm.util.Tools();
    
    if (timer) {
        window.clearInterval(timer);
    }
    //打开连接开心农场提示信息
    openDialog("connDialog");

    window.setTimeout(function(){
        
        var appLoader = new happyfarm.util.AppLoader();
        var job = new happyfarm.util.Job();
        //初始化全部农作物的信息
        cropsInfo = job.getSeedInfo();
        if (cropsInfo == null) {
            //关闭连接开心农场提示信息
            closeDialog("connDialog");
            alert("商店信息取得失败，请重新“连接农场”！");
            return;
        } else if (cropsInfo.errorType) {
            if(cropsInfo.errorType == "validateCode"){
				document.getElementById("validate").style.visibility = "visible";
				document.getElementById('verifycode').value = "";
				document.getElementById('verifycode').focus();
				document.getElementById("validateImg").src = "http://ptlogin2.qq.com/getimage?aid=353&"+Math.random();
				if(document.getElementById("alertSound").checked){
					if(navigator.userAgent.indexOf("Firefox") > 0){
						try{
							document.getElementById('sound_ff').Play();
						}catch(e){}
						alert("请输入验证码！");
					}else{
						document.getElementById('sound_ie').src=document.getElementById('alertSysSound').value;
					}
				}
				doValidate = function (){
					validateCode = document.getElementById("verifycode").value;
					document.getElementById("validate").style.visibility = "hidden";
					document.getElementById('sound_ie').src='';
					if(navigator.userAgent.indexOf("Firefox") > 0){
						try{
							document.getElementById('sound_ff').Stop();
						}catch(e){}
					}
					document.getElementById("connBtn").onclick = function(){initialization();}; 
					initialization();
				};
				//避免触发器其他事件
				document.getElementById("connBtn").onclick = function(){}; 
			}else{
				//关闭连接开心农场提示信息
				closeDialog("connDialog");
				alert("农场连接失败，可能是由于没有登录！");
			}
            return;
        }
		
        //生成登录人的信息
        var result = job.getUserInfo();
        var levelArray = tools.getLevel(result.exp);
        document.getElementById("myPic").src = result.user.headPic;
        document.getElementById("myName").innerHTML = result.user.userName;
        document.getElementById("myExp").innerHTML = result.exp;
        document.getElementById("myMoney").innerHTML = result.user.money;
        document.getElementById("myLevel").innerHTML = levelArray[0];
        document.getElementById("myLastExp").innerHTML = levelArray[1];
        //document.getElementById("myFb").innerHTML = result.user.FB;
        if (result.weather) {
            document.getElementById("myWeather").innerHTML = result.weather.weatherDesc;
        }
        
		//取得用户农场信息,并生成列表
		appLoader.getFarmConfig(result.farmlandStatus);
		farmArray = result.farmlandStatus;
		
        //取得仓库信息
        getUserCrop();
		
        //取得远程所有好友列表
        userArray = job.getUserList(result);
        if (userArray == null) {
            //关闭连接开心农场提示信息
            closeDialog("connDialog");
            alert("好友列表获取失败，请重新“连接农场”！");
            return;
        } else if (userArray.errorType) {
            if(userArray.errorType == "validateCode"){
				document.getElementById("validate").style.visibility = "visible";
				document.getElementById('verifycode').value = "";
				document.getElementById('verifycode').focus();
				document.getElementById("validateImg").src = "http://ptlogin2.qq.com/getimage?aid=353&"+Math.random();
				if(document.getElementById("alertSound").checked){
					if(navigator.userAgent.indexOf("Firefox") > 0){
						try{
							document.getElementById('sound_ff').Play();
						}catch(e){}
						alert("请输入验证码！");
					}else{
						document.getElementById('sound_ie').src=document.getElementById('alertSysSound').value;
					}
				}
				doValidate = function (){
					validateCode = document.getElementById("verifycode").value;
					document.getElementById("validate").style.visibility = "hidden";
					document.getElementById('sound_ie').src='';
					if(navigator.userAgent.indexOf("Firefox") > 0){
						try{
							document.getElementById('sound_ff').Stop();
						}catch(e){}
					}
					document.getElementById("connBtn").onclick = function(){initialization();}; 
					initialization();
				};
				//避免触发器其他事件
				document.getElementById("connBtn").onclick = function(){}; 
			}else{
				//关闭连接开心农场提示信息
				closeDialog("connDialog");
				alert("农场连接失败，可能是由于没有登录！");
			}
            return;
        }
        
		//取得偷菜配置文件，并生成列表
		appLoader.getCropsConfig();
        //取得系统配置文件
        appLoader.getSysConfig();
        //取得本地好友配置文件，并生成列表
        appLoader.getfriendConfig();
		
        //取得用户背包信息
		getUserSeed();
        
        //显示高级选项
        showTab(6);
        
        document.getElementById("startBtn").disabled = false;
        document.getElementById("userCrop").disabled = false;
        document.getElementById("saleAllCrops").disabled = false;
        document.getElementById("expBtn").disabled = false;
        document.getElementById("saveFriend").disabled = false;
        document.getElementById("saveSystem").disabled = false;
		document.getElementById("refreshUserSeed").disabled = false;
        document.getElementById("connBtn").disabled = true;
        //关闭连接开心农场提示信息
        closeDialog("connDialog");
        alert("农场连接成功！");
    }, 0);
    
    //版本检测
    window.setTimeout(function(){
        var appLoader = new happyfarm.util.AppLoader();
        appLoader.checkUpgrade();
    }, 0);
}

//取得用户背包信息
function getUserSeed(){
	var job = new happyfarm.util.Job();
	try {
		var result = job.getUserSeed();
		readyCrops = new Array();
		for (var i = 0; i < result.length; i++) {
			//生成种子列表
			if (result[i].type == 1) {
				for (var j = 0; j < result[i].amount; j++) {
					appLoader.addReadyCrops(result[i].cId, result[i].cName, 1);
				}
			}
			//生成普通化肥
			if (result[i].type == 3 && result[i].tId == 1) {
				fertilizerNum = result[i].amount;
			}
		}
	} catch (e) {
    
    }
}

//取得用户仓库信息
function getUserCrop(){
    var job = new happyfarm.util.Job();
    //取得用户仓库信息
    try {
        var userCrop = job.getUserCrop();
        if (userCrop) {
            var sumCrop = 0;
            var sumPrice = 0;
            for (var i = 0; i < userCrop.length; i++) {
                sumCrop += parseInt(userCrop[i].amount);
                sumPrice += parseInt(userCrop[i].amount) * parseInt(userCrop[i].price);
            }
            document.getElementById("sumCrop").innerHTML = sumCrop;
            document.getElementById("sumPrice").innerHTML = sumPrice;
        }
    } catch (e) {
    
    }
}

//变卖全部果实
function saleAllCrops(){
    var job = new happyfarm.util.Job();
    //取得用户仓库信息
    try {
        job.saleAllCrops();
        getUserCrop();
        //生成登录人的信息
        var result = job.getUserInfo();
        
        if (result) {
            if (result.user) {
                var levelArray = tools.getLevel(result.exp);
                document.getElementById("myPic").src = result.user.headPic;
                document.getElementById("myName").innerHTML = result.user.userName;
                document.getElementById("myExp").innerHTML = result.exp;
                document.getElementById("myMoney").innerHTML = result.user.money;
                document.getElementById("myLevel").innerHTML = levelArray[0];
                document.getElementById("myLastExp").innerHTML = levelArray[1];
                //document.getElementById("myFb").innerHTML = result.user.FB;
                //document.getElementById("myWeather").innerHTML = result.weather.weatherDesc;
            }
        }
    } catch (e) {
    
    }
}

//刷经验
function startExp(){
    document.getElementById("startBtn").disabled = true;
    
    //初期化expInfo
    var expInfo = window.frames["expInfo"];
    var userExpList = expInfo.document.getElementById("userExpList");
    while (userExpList.childNodes.length > 0) {
        userExpList.removeChild(userExpList.childNodes[0]);
    }
    
    //创建一个线程
    Concurrent.Thread.create(mainExp);
}

function mainExp(){
    var job = new happyfarm.util.Job();
    var tools = new happyfarm.util.Tools();
    var request = new happyfarm.util.Request();
    
    //如果启动种白萝卜刷经验功能
    var num = document.getElementById("num").value;
    
    var blbNum = 0;
    var warehouse = job.getUserCrop();
    for (var i = 0; i < warehouse.length; i++) {
        //生成种子列表
        if (warehouse[i].type == 1) {
            //判断背包中有多少牧草
            if (warehouse[i].cId == "40") {
                blbNum = warehouse[i].amount;
            }
        }
    }
    
    if (num - blbNum > 0) {
        //购买指定数量牧草
        job.buySeeds("40", num - blbNum);
    }
    
    var hoeingSum = 0;
    var farmingSum = 0;
    
	var brushExpInterval = parseInt(document.getElementById("brushExpInterval").value);
    //在第一块农田上刷经验
    for (var i = 0; i < num; i++) {
		var hoeingCount = 0;
		var farmingCount = 0;
		
        landRow = document.createElement("tr");
        landRow.setAttribute("id", "landRow" + i);
        landRow.setAttribute("align", "center");
        //隔行换色
        if (i % 2 != 0) {
            landRow.setAttribute("class", "row-bgcolor");
            landRow.setAttribute("className", "row-bgcolor");
        }
        
        landCell = document.createElement("td");
        landCell.appendChild(document.createTextNode("第" + (i + 1) + "次"));
        landRow.appendChild(landCell);
        
        //锄地
        var hoeingExp = job.hoeing(myId, 0);
		if(hoeingExp){
			if(hoeingExp.exp){
				hoeingCount = hoeingExp.exp;
				hoeingSum += hoeingExp.exp;
			}
		}
        
        landCell = document.createElement("td");
        landCell.appendChild(document.createTextNode(hoeingCount));
        landRow.appendChild(landCell);
        
        //种地
        var farmingExp = job.farming("40", myId, 0);
		if(farmingExp){
			if(farmingExp.exp){
				farmingCount = farmingExp.exp;
				farmingSum += farmingExp.exp;
			}
		}
        
        landCell = document.createElement("td");
        landCell.appendChild(document.createTextNode(farmingCount));
        landRow.appendChild(landCell);
        
        landCell = document.createElement("td");
        landCell.appendChild(document.createTextNode("完成"));
        landRow.appendChild(landCell);
        
        //生成一个人的农场信息
        window.frames["expInfo"].document.getElementById("userExpList").appendChild(landRow);
        
        //生成的收获信息合计
        window.frames["expInfo"].document.getElementById("hoeingSum").innerHTML = hoeingSum;
        window.frames["expInfo"].document.getElementById("farmingSum").innerHTML = farmingSum;
        
        //更新萝卜数量
        document.getElementById("num").value = document.getElementById("num").value - 1;
        
        window.frames["expInfo"].scrollTo(0, document.body.scrollHeight);
        
        //线程中断brushExpInterval秒
        Concurrent.Thread.sleep(brushExpInterval);
    }
    
    //生成登录人的信息
    var result = job.getUserInfo();
    
    if (result) {
        if (result.user) {
            var levelArray = tools.getLevel(result.exp);
            document.getElementById("myPic").src = result.user.headPic;
            document.getElementById("myName").innerHTML = result.user.userName;
            document.getElementById("myExp").innerHTML = result.exp;
            document.getElementById("myMoney").innerHTML = result.user.money;
            document.getElementById("myLevel").innerHTML = levelArray[0];
            document.getElementById("myLastExp").innerHTML = levelArray[1];
            //document.getElementById("myFb").innerHTML = result.user.FB;
            //document.getElementById("myWeather").innerHTML = result.weather.weatherDesc;
        }
    }
    
    alert("已完成！");
    
    closeDialog("expDialog");
    
    document.getElementById("startBtn").disabled = false;
    
    window.setTimeout(function(){
        warehouse = request.doGet("repertory", "getUserSeed");
        warehouse = eval('(' + warehouse + ')');
        
        //初始化
        readyCrops = new Array();
        for (var i = 0; i < warehouse.length; i++) {
            //生成种子列表
            if (warehouse[i].type == 1) {
                for (var j = 0; j < warehouse[i].amount; j++) {
                    appLoader.addReadyCrops(warehouse[i].cId, warehouse[i].cName, 1);
                }
            }
        }
    }, 0);
}

function startApp(){
    //初期化自动维护倒计时器
	for(var i=0;i<10;i++){
    	window.clearInterval(interval[i]);
	}
	window.clearInterval(intervalNext);
    window.clearTimeout(timeout);
	
	//刷新QQ空间
	if(!intervalQQ){
    	intervalQQ = window.setInterval(function(){document.getElementById("login_frame").innerHTML = '<iframe id="userLogin" name="userLogin" src="http://huifu.qq.com/cgi-bin/show_index" class="login" align="center" frameborder="0" scrolling="no" application="true"></iframe>';}, parseInt(document.getElementById("brushQQInterval").value)*60*1000);
	}
	
    //目标农田信息集合初始化
    targetMission = [];
	
    document.getElementById("cropSum").innerHTML = 0;
    //不同浏览器不同的清空方法，FF效率最好
    if (navigator.userAgent.indexOf("Firefox") > 0) {
        //初期化userLandList
        document.getElementById("userLandList").innerHTML = "";
        //初期化userHarvestList
        document.getElementById("userHarvestList").innerHTML = "";
        //初期化immediateList
        document.getElementById("immediateList").innerHTML = "";
    } else if (navigator.userAgent.indexOf("MSIE") > 0) {
        //初期化userLandList
        var userLandInfo = document.getElementById("userLandList");
        while (userLandInfo.childNodes.length > 0) {
            userLandInfo.removeChild(userLandInfo.childNodes[0]);
        }
        
        //初期化userHarvestList
        var userHarvestInfo = document.getElementById("userHarvestList");
        while (userHarvestInfo.childNodes.length > 0) {
            userHarvestInfo.removeChild(userHarvestInfo.childNodes[0]);
        }
        
        //初期化immediateList
        var immediateList = document.getElementById("immediateList");
        while (immediateList.childNodes.length > 0) {
            immediateList.removeChild(immediateList.childNodes[0]);
        }
    }
    //初期化dialog
    document.getElementById("progMain").innerHTML = "0%";
    document.getElementById("progMain").style.width = "";
    document.getElementById("progSub").innerHTML = "0%";
    document.getElementById("progSub").style.width = "";
    
	//相关设定读取
	window.borers_run = document.getElementById("borers").checked;
	window.weeds_run = document.getElementById("weeds").checked;
	window.dryland_run = document.getElementById("dryland").checked;
	window.auto_crops_run = document.getElementById("Auto-crops").checked;
	window.auto_farm_run = document.getElementById("Auto-farm").checked;
	window.dog_run = document.getElementById("dog").checked;
	window.crope_run = document.getElementById("crope").checked;
	window.dogCrops1_id = document.getElementById("dogCrops1").value;
	window.dogCrops2_id = document.getElementById("dogCrops2").value;
	window.dogCrops3_id = document.getElementById("dogCrops3").value;
	window.intervalTimeValue = document.getElementById("intervalTimeValue").value;
	window.intervalTimeCheck = document.getElementById("intervalTimeCheck").checked;
	
    //显示dialog
    openDialog("proDialog");
    
    //默认显示收获明细
    showTab(1);
	
	var job = new happyfarm.util.Job();
    //遍历所有田地上的农作物信息
    job.loadFarmland(0);
	
}

defClass(happyfarm.util, "AppLoader", null, function(AppLoader, AppLoader_prototype){
    AppLoader_prototype.init = function(){
		
    };
    
	AppLoader_prototype.runMission = function(){
		var tools = new happyfarm.util.Tools();
		var job = new happyfarm.util.Job();
		//生成登录人的信息
		var result = job.getUserInfo();
		if (result) {
			if (result.user) {
				var levelArray = tools.getLevel(result.exp);
				document.getElementById("myPic").src = result.user.headPic;
				document.getElementById("myName").innerHTML = result.user.userName;
				document.getElementById("myExp").innerHTML = result.exp;
				document.getElementById("myMoney").innerHTML = result.user.money;
				document.getElementById("myLevel").innerHTML = levelArray[0];
				document.getElementById("myLastExp").innerHTML = levelArray[1];
				//document.getElementById("myFb").innerHTML = result.user.FB;
				//document.getElementById("myWeather").innerHTML = result.weather.weatherDesc;
			}
		}
		
		//取得用户仓库信息
		getUserCrop();
		
		if(targetMission.length==0){
			return;	
		}
		
		//排序任务列表
		targetMission.sort(function(a, b){
			return (parseInt(a["time"]) + parseInt(a["serverTime"])) - (parseInt(b["time"]) + parseInt(b["serverTime"]));
		});
		
		//忽略本次维护完成成熟的农作物
		if(document.getElementById("ignoreCrops").checked){
			while (true) {
				//忽略本次维护完成成熟的农作物，并延迟5秒判断
				if (targetMission[0].time - (tools.getLocalTime() - targetMission[0].localTime) - 3 < 0){
					targetMission.splice(0, 1);
				}else{
					break;	
				}
			}
		}
		
		//设定维护间隔
		var nextTime = parseInt(document.getElementById("time").value) * 60;
		timeout = window.setTimeout(startApp, nextTime * 1000);
		intervalNext = window.setInterval(function(){document.getElementById("nextRunTime").innerHTML = tools.culTime(nextTime--);}, 1000);
		//滚动条复位
		window.scrollTo(0, 0);
		
		//设定线程数目
		if(document.getElementById("threadNum").value != "" && !isNaN(document.getElementById("threadNum").value)){
			threadNum = parseInt(document.getElementById("threadNum").value);
		}else{
			threadNum = 5;	
		}
		
		//设定重试间隔
		if(document.getElementById("retryTime").value == "" && isNaN(document.getElementById("retryTime").value)){
			document.getElementById("retryTime").value = 100;
		}
		retryTime = parseInt(document.getElementById("retryTime").value);
		
		//设定重试次数
		if(document.getElementById("retry").value == "" && isNaN(document.getElementById("retry").value)){
			document.getElementById("retry").value = 5;
		}
		retry = parseInt(document.getElementById("retry").value);
		
		//临时计数
		var n = 0;
		for (var i = 0; i < targetMission.length; i++) {
			//只取出指定维护范围内的任务数据
			if (targetMission[i].time - (tools.getLocalTime() - targetMission[i].localTime) > nextTime) {
				if (n++ == threadNum) {
					break;
				}
			}
			//在即时明细中添加一条信息
			var cell, row;
			row = document.createElement("tr");
			row.setAttribute("align", "center");
			//给自己信息行特别颜色
			if (targetMission[i].owner.uId == myId) {
				row.setAttribute("class", "my-row-bgcolor");
				row.setAttribute("className", "my-row-bgcolor");
			} else {
				//隔行换色
				if (i % 2 != 0) {
					row.setAttribute("class", "row-bgcolor");
					row.setAttribute("className", "row-bgcolor");
				}
			}
			cell = document.createElement("td");
			cell.appendChild(document.createTextNode(i + 1));
			row.appendChild(cell);
			cell = document.createElement("td");
			cell.appendChild(document.createTextNode(targetMission[i].owner.indexId + 1));
			row.appendChild(cell);
			cell = document.createElement("td");
			if(targetMission[i].owner.uin){
				cell.appendChild(document.createTextNode("空间"));
			}else{
				cell.appendChild(document.createTextNode("校友"));
			}
			row.appendChild(cell);
			cell = document.createElement("td");
			cell.appendChild(document.createTextNode(targetMission[i].owner.userName));
			row.appendChild(cell);
			cell = document.createElement("td");
			cell.appendChild(document.createTextNode(tools.getLevel(targetMission[i].owner.exp)[0]));
			row.appendChild(cell);
			cell = document.createElement("td");
			cell.appendChild(document.createTextNode(targetMission[i].owner.exp));
			row.appendChild(cell);
			cell = document.createElement("td");
			cell.appendChild(document.createTextNode(targetMission[i].owner.money));
			row.appendChild(cell);
			cell = document.createElement("td");
			if(targetMission[i].dogIsHungry){
				cell.appendChild(document.createTextNode("●"));
			}
			row.appendChild(cell);
			cell = document.createElement("td");
			cell.appendChild(document.createTextNode("第" + (parseInt(targetMission[i].farmIndex) + 1) + "块"));
			row.appendChild(cell);
			cell = document.createElement("td");
			cell.appendChild(document.createTextNode(targetMission[i].farm.cName));
			row.appendChild(cell);
			cell = document.createElement("td");
			cell.setAttribute("id", "cropsCount_" + targetMission[i].owner.uId + "_" + targetMission[i].farmIndex);
			cell.appendChild(document.createTextNode(""));
			row.appendChild(cell);
			cell = document.createElement("td");
			cell.setAttribute("id", "cropsDirection_" + targetMission[i].owner.uId + "_" + targetMission[i].farmIndex);
			row.appendChild(cell);
			cell = document.createElement("td");
			cell.setAttribute("id", "cropsState_" + targetMission[i].owner.uId + "_" + targetMission[i].farmIndex);
			cell.appendChild(document.createTextNode("等待中..."));
			row.appendChild(cell);
			cell = document.createElement("td");
			cell.appendChild(document.createTextNode(tools.toUnixTime(parseInt(targetMission[i].serverTime) + parseInt(targetMission[i].time))));
			row.appendChild(cell);
			
			//生成一个人的收获信息
			document.getElementById("immediateList").appendChild(row);
		}
		
		//设定好友提前时间
		bTime = parseFloat(document.getElementById("beforeTime").value);
		//设定自己提前时间
        my_bTime = parseFloat(document.getElementById("myBeforeTime").value);
		
		//初始化最小线程
		minMisId = 0;
		//设定当前最大线程所对应的任务编号
		maxMisId = threadNum - 1;
		for (var i = 0; i < threadNum; i++) {
			(function(misId, job, tools, appLoader){
				interval[misId] = setInterval(function(){
					appLoader.getNextTime(misId, misId, job, tools, appLoader);
				}, 1000);
			})(i, job, tools, appLoader);
		}
		
		//默认显示任务明细
		showTab(3);
		
		document.title = "解放农民(开心农场助手)QQ版";
	};

    //生成每块土地的详细信息
    AppLoader_prototype.creatDetails = function(){
		var tools = new happyfarm.util.Tools();
		//统计数量用,初期化
        var borersSum = 0;
        var weedsSum = 0;
        var drylandSum = 0;
        var cropsSum = 0;
        var expSum = 0;
        var goldSum = 0;
		
		var lineIndex = 0;
		for(var i=0;i<userArray.length;i++){
			var weedsCount = 0;
			var borersCount = 0;
			var drylandCount = 0;
			var cropCount = 0;
			if(userArray[i].check && userArray[i].farmlandStatus){
				//生成必要的统计信息
				for(var j=0;j<userArray[i].farmlandStatus.length;j++){
					//除草小计计算
					weedsCount += userArray[i].farmlandStatus[j].weedsCount;
					//杀虫小计计算
					borersCount += userArray[i].farmlandStatus[j].borersCount;
					//收获果实小计计算
					cropCount += userArray[i].farmlandStatus[j].cropCount;
					
					//旱地小计计算
					if(userArray[i].farmlandStatus[j].dryLand){
						drylandCount += 1;
					}
				}
				
				//杀虫合计计算
				borersSum += borersCount;
				//除草合计计算
				weedsSum += weedsCount;
				//旱地合计计算
				drylandSum += drylandCount;
				//收获果实合计计算
				cropsSum += cropCount;
				//经验合计计算
				expSum += userArray[i].expCount;
				//经验金币计算
				goldSum += userArray[i].glodCount;
				
				//如果需要显示收获明细
				if(document.getElementById("harvestDetail").checked){
					//************************生成收获明细列表**********************
					var harvestRow = document.createElement("tr");
					harvestRow.setAttribute("id", "harvestRow" + i);
					harvestRow.setAttribute("align", "center");
					//给自己信息行特别颜色
					if (userArray[i].uId == myId) {
						harvestRow.setAttribute("class", "my-row-bgcolor");
						harvestRow.setAttribute("className", "my-row-bgcolor");
					} else {
						//隔行换色
						if (lineIndex++ % 2 != 0) {
							harvestRow.setAttribute("class", "row-bgcolor");
							harvestRow.setAttribute("className", "row-bgcolor");
						}
					}
					var harvestCell = document.createElement("td");
					harvestCell.appendChild(document.createTextNode(i + 1));
					harvestRow.appendChild(harvestCell);
					harvestCell = document.createElement("td");
					harvestCell.appendChild(document.createTextNode(userArray[i].userName));
					harvestRow.appendChild(harvestCell);
					harvestCell = document.createElement("td");
					harvestCell.appendChild(document.createTextNode(tools.getLevel(userArray[i].exp)[0]));
					harvestRow.appendChild(harvestCell);
					harvestCell = document.createElement("td");
					harvestCell.appendChild(document.createTextNode(userArray[i].exp));
					harvestRow.appendChild(harvestCell);
					harvestCell = document.createElement("td");
					harvestCell.appendChild(document.createTextNode(userArray[i].money));
					harvestRow.appendChild(harvestCell);
					harvestCell = document.createElement("td");
					harvestCell.appendChild(document.createTextNode(weedsCount));
					harvestRow.appendChild(harvestCell);
					harvestCell = document.createElement("td");
					harvestCell.appendChild(document.createTextNode(borersCount));
					harvestRow.appendChild(harvestCell);
					harvestCell = document.createElement("td");
					harvestCell.appendChild(document.createTextNode(drylandCount));
					harvestRow.appendChild(harvestCell);
					harvestCell = document.createElement("td");
					harvestCell.appendChild(document.createTextNode(cropCount));
					harvestRow.appendChild(harvestCell);
					harvestCell = document.createElement("td");
					harvestCell.appendChild(document.createTextNode(userArray[i].expCount));
					harvestRow.appendChild(harvestCell);
					harvestCell = document.createElement("td");
					harvestCell.appendChild(document.createTextNode(userArray[i].glodCount));
					harvestRow.appendChild(harvestCell);
					
					//生成一个人的收获信息
					document.getElementById("userHarvestList").appendChild(harvestRow);
				}
				//如果需要显示农场明细
				if(document.getElementById("farmDetail").checked){
					//************************生成农场明细列表**********************
					var landRow = document.createElement("tr");
					landRow.setAttribute("id", "landRow" + i);
					landRow.setAttribute("align", "center");
					//给自己信息行特别颜色
					if (userArray[i].uId == myId) {
						landRow.setAttribute("class", "my-row-bgcolor");
						landRow.setAttribute("className", "my-row-bgcolor");
					} else {
						//隔行换色
						if (lineIndex % 2 != 0) {
							landRow.setAttribute("class", "row-bgcolor");
							landRow.setAttribute("className", "row-bgcolor");
						}
					}
					
					landCell = document.createElement("td");
					landCell.appendChild(document.createTextNode(userArray[i].userName));
					landRow.appendChild(landCell);
					//显示农场是否有狗
					landCell = document.createElement("td");
					if(userArray[i].dog){
						landCell.appendChild(document.createTextNode("狗"));
					}
					landRow.appendChild(landCell);
					
					//遍历每块农田信息
					for(var j=0;j<userArray[i].farmlandStatus.length;j++){
						landCell = document.createElement("td");
						
						var landTable, landTbody, landTrow, landTcell;
						landTable = document.createElement("table");
						landTbody = document.createElement("tbody");
						landTrow = document.createElement("tr");
						//显示农田状态
						landTcell = document.createElement("td");
						landTcell.appendChild(document.createTextNode(userArray[i].farmlandStatus[j].landStatus));
						landTrow.appendChild(landTcell);
						//是否有草
						landTcell = document.createElement("td");
						if(userArray[i].farmlandStatus[j].weedsCount > 0){
							landTcell.setAttribute("bgcolor", "#FFFF00");
							landTcell.setAttribute("class", "weeds-bgcolor");
							landTcell.setAttribute("className", "weeds-bgcolor");
							landTcell.appendChild(document.createTextNode(userArray[i].farmlandStatus[j].weedsCount));
						}
						landTrow.appendChild(landTcell);
						//是否有虫
						landTcell = document.createElement("td");
						if(userArray[i].farmlandStatus[j].weedsCount > 0){
							landTcell.setAttribute("bgcolor", "#FFFF00");
							landTcell.setAttribute("class", "borers-bgcolor");
							landTcell.setAttribute("className", "borers-bgcolor");
							landTcell.appendChild(document.createTextNode(userArray[i].farmlandStatus[j].weedsCount));
						}
						landTrow.appendChild(landTcell);
						//是否干旱
						landTcell = document.createElement("td");
						if(userArray[i].farmlandStatus[j].dryLand){
							landTcell.setAttribute("bgcolor", "#FFFF00");
							landTcell.setAttribute("class", "dryland-bgcolor");
							landTcell.setAttribute("className", "dryland-bgcolor");
							landTcell.appendChild(document.createTextNode("旱"));
						}
						landTrow.appendChild(landTcell);
						landTbody.appendChild(landTrow);
						landTable.appendChild(landTbody);
						landCell.appendChild(landTable);
						
						//收获果实状态
						landTable = document.createElement("table");
						landTbody = document.createElement("tbody");
						landTrow = document.createElement("tr");
						landTcell = document.createElement("td");
						landTcell.setAttribute("id", userArray[i].uId + "_" + j);
						if(userArray[i].farmlandStatus[j].cropStatus == -1){
							//显示成熟剩余时间
							if(userArray[i].farmlandStatus[j].time != 0){
								landTcell.appendChild(document.createTextNode(userArray[i].farmlandStatus[j].time));
							}
						}
						if(userArray[i].farmlandStatus[j].cropStatus == 0){
							if(userArray[i].farmlandStatus[j].cropCount > 0){
								landTcell.setAttribute("class", "crops-bgcolor");
								landTcell.setAttribute("className", "crops-bgcolor");
								if(userArray[i].uId == myId){
									landTcell.appendChild(document.createTextNode("成熟(丰收)"));
								}else{
									landTcell.appendChild(document.createTextNode("成熟(成功)"));
								}
							}else{
								landTcell.appendChild(document.createTextNode("成熟(失败)"));
							}
						}else if(userArray[i].farmlandStatus[j].cropStatus == 1){
							landTcell.appendChild(document.createTextNode("成熟(不偷)"));
						}else if(userArray[i].farmlandStatus[j].cropStatus == 2){
							landTcell.appendChild(document.createTextNode("成熟(有狗)"));
						}else if(userArray[i].farmlandStatus[j].cropStatus == 3){
							landTcell.appendChild(document.createTextNode("成熟(无果)"));
						}else if(userArray[i].farmlandStatus[j].cropStatus == 4){
							landTcell.appendChild(document.createTextNode("成熟(偷过)"));
						}
						landTrow.appendChild(landTcell);
						landTbody.appendChild(landTrow);
						landTable.appendChild(landTbody);
						
						landCell.appendChild(landTable);
						//添加到数据行
						landRow.appendChild(landCell);
					}
					//生成一个人的农场信息
					document.getElementById("userLandList").appendChild(landRow);
				}
			}
			//生成的收获信息合计
			document.getElementById("weedsSum").innerHTML = weedsSum;
			document.getElementById("borersSum").innerHTML = borersSum;
			document.getElementById("drylandSum").innerHTML = drylandSum;
			document.getElementById("cropsSum").innerHTML = cropsSum;
			document.getElementById("experienceSum").innerHTML = expSum;
			document.getElementById("goldCoinSum").innerHTML = goldSum;
		}
    };
    
    //创建好友列表
    AppLoader_prototype.creatFriendList = function(i){
        var me = this;
        
        var tools = new happyfarm.util.Tools();
        
        var row, cell, flistBtn;
        row = document.createElement("tr");
        //row.setAttribute("id", userArray[i].uId);
        row.setAttribute("align", "center");
        //隔行换色
        if (i % 2 != 0) {
            row.setAttribute("class", "row-bgcolor");
            row.setAttribute("className", "row-bgcolor");
        }
        cell = document.createElement("td");
        cell.appendChild(document.createTextNode(i + 1));
        row.appendChild(cell);
        cell = document.createElement("td");
        cell.appendChild(document.createTextNode(userArray[i].userName));
        row.appendChild(cell);
        cell = document.createElement("td");
        cell.appendChild(document.createTextNode(tools.getLevel(userArray[i].exp)[0]));
        row.appendChild(cell);
        cell = document.createElement("td");
        cell.appendChild(document.createTextNode(userArray[i].exp));
        row.appendChild(cell);
        cell = document.createElement("td");
        cell.appendChild(document.createTextNode(userArray[i].money));
        row.appendChild(cell);
        cell = document.createElement("td");
        flistBtn = document.createElement("input");
        flistBtn.setAttribute("id", userArray[i].uId);
        flistBtn.setAttribute("type", "checkbox");
        //flistBtn.setAttribute("checked", "true");IE不支持
        flistBtn.onclick = function(){
            me.friendChoose(this);
        };
        cell.appendChild(flistBtn);
        row.appendChild(cell);
        
        document.getElementById("friendList").appendChild(row);
        
        if (friendRecords != null && friendRecords.length > 0) {
        
            //非首次生成
            for (var j = 0; j < friendRecords.length; j++) {
                if (userArray[i].uId == friendRecords[j].getAttribute("userId")) {
                    if (friendRecords[j].getAttribute("check") == "true") {
                        userArray[i]["check"] = true;
                    } else {
                        userArray[i]["check"] = false;
                    }
                    break;
                }
            }
        } else {
            //首次生成列表时默认全选
            userArray[i]["check"] = true;
        }
        document.getElementById(userArray[i].uId).checked = userArray[i]["check"];
    };
    
    AppLoader_prototype.creatCropsList = function(i){
        var me = this;
        //生成默认播种种子列表
        document.getElementById("defult-crop").options[document.getElementById("defult-crop").options.length] = new Option(cropsInfo[i].cName, cropsInfo[i].cId);
        //生成默认播种红种子列表
		if(cropsInfo[i].cId > 200 || cropsInfo[i].cId == "126"){
			document.getElementById("defult-red-crop").options[document.getElementById("defult-red-crop").options.length] = new Option(cropsInfo[i].cName, cropsInfo[i].cId);
		}
		//生成有狗粮不偷种子列表1
        document.getElementById("dogCrops1").options[document.getElementById("dogCrops1").options.length] = new Option(cropsInfo[i].cName, cropsInfo[i].cId);
		//生成有狗粮不偷种子列表2
        document.getElementById("dogCrops2").options[document.getElementById("dogCrops2").options.length] = new Option(cropsInfo[i].cName, cropsInfo[i].cId);
		//生成有狗粮不偷种子列表3
		document.getElementById("dogCrops3").options[document.getElementById("dogCrops3").options.length] = new Option(cropsInfo[i].cName, cropsInfo[i].cId);
        
        //生成农作物种子列表
        var cropsRow = document.createElement("tr");
        cropsRow.setAttribute("id", "cropsRow" + i);
        cropsRow.setAttribute("align", "center");
        //隔行换色
        if (i % 2 != 0) {
            cropsRow.setAttribute("class", "row-bgcolor");
            cropsRow.setAttribute("className", "row-bgcolor");
        }
        var cropsCell = document.createElement("td");
		var ropsButton = document.createElement("input");
        ropsButton.setAttribute("id", "c_"+cropsInfo[i].cId);
        ropsButton.setAttribute("type", "checkbox");
        //ropsButton.setAttribute("checked", "false"); 低版本IE不支持
        ropsButton.onclick = function(){
            me.cropsChoose(this);
        };
        cropsCell.appendChild(ropsButton);
        cropsRow.appendChild(cropsCell);
		cropsCell = document.createElement("td");
        cropsCell.appendChild(document.createTextNode(cropsInfo[i].cId));
        cropsRow.appendChild(cropsCell);
        cropsCell = document.createElement("td");
        cropsCell.appendChild(document.createTextNode(cropsInfo[i].cName));
        cropsRow.appendChild(cropsCell);
        cropsCell = document.createElement("td");
        cropsCell.appendChild(document.createTextNode(parseInt(cropsInfo[i].growthCycle) / 3600));
        cropsRow.appendChild(cropsCell);
        cropsCell = document.createElement("td");
        cropsCell.appendChild(document.createTextNode(cropsInfo[i].maturingTime));
        cropsRow.appendChild(cropsCell);
        cropsCell = document.createElement("td");
        cropsCell.appendChild(document.createTextNode(cropsInfo[i].expect));
        cropsRow.appendChild(cropsCell);
        cropsCell = document.createElement("td");
        cropsCell.appendChild(document.createTextNode(cropsInfo[i].output));
        cropsRow.appendChild(cropsCell);
        cropsCell = document.createElement("td");
        cropsCell.appendChild(document.createTextNode(cropsInfo[i].sale));
        cropsRow.appendChild(cropsCell);
        cropsCell = document.createElement("td");
        cropsCell.appendChild(document.createTextNode(cropsInfo[i].price));
        cropsRow.appendChild(cropsCell);
        cropsCell = document.createElement("td");
        cropsCell.appendChild(document.createTextNode(cropsInfo[i].cLevel));
        cropsRow.appendChild(cropsCell);
        cropsCell = document.createElement("td");
        cropsCell.appendChild(document.createTextNode(cropsInfo[i].cropExp));
        cropsRow.appendChild(cropsCell);
        
        //生成商店信息
        document.getElementById("crops").appendChild(cropsRow);
		
		//生成备选种子列表
        var cId = cropsInfo[i].cId;
		var cName = cropsInfo[i].cName;
		var shop = document.getElementById("shop");
		var seed = document.createElement("div");
		seed.id = cId;
		if(cId>200 || cId=="126"){
			seed.className = "seedRed";
		}else{
			seed.className = "seed";
		}
		seed.onclick = function(){
			if(selectFarm == null){
				alert("请选择一块农田！");
			}else{
				var farm = document.getElementById("farmContent" + selectFarm);
				var farmTitle = document.getElementById("farmContent" + selectFarm);
				//红土地必须中红土地种子
				if(farmTitle.innerHTML.indexOf("红") < 0 && (cId>200 || cId=="126")){
					alert("红土地种子只能播种在红土地！");
				}
				//判断子节点个数，超过3个不予追加种子。
				if(farm.childNodes.length != 3){
					var seedCopy = seed.cloneNode(true);
					seedCopy.style.width="100%";
					seedCopy.onclick = function(){
						seedCopy.parentNode.removeChild(seedCopy);
					}
					farm.appendChild(seedCopy);
				}
			}
		}
		var seedName = document.createTextNode(cName);
		seed.appendChild(seedName);
		shop.appendChild(seed);
		
		if (cropsRecords != null && cropsRecords.length > 0) {
        
            //非首次生成
            for (var j = 0; j < cropsRecords.length; j++) {
                if (cropsInfo[i].cId == cropsRecords[j].getAttribute("cId")) {
                    if (cropsRecords[j].getAttribute("check") == "true") {
                        cropsInfo[i]["check"] = true;
                    } else {
                        cropsInfo[i]["check"] = false;
                    }
                    break;
                }
            }
        } else {
            //首次生成列表时默认全选
            cropsInfo[i]["check"] = true;
        }
        document.getElementById("c_"+cropsInfo[i].cId).checked = cropsInfo[i]["check"];
    };
    
    //更新倒计时的时间
    AppLoader_prototype.getNextTime = function(misId, timer, job, tools, appLoader){
		var next = false;
		var mission = targetMission[misId];
        minTime = parseInt(mission.time) - (tools.getLocalTime() - mission.localTime);
		
		//判断是否执行该任务
		if(!mission.run){
			next = true;
		}
        
        if (document.getElementById("s-theft").checked) {
            if (minTime > 0) {
				document.getElementById("cropsState_" + mission.owner.uId + "_" + mission.farmIndex).innerHTML = tools.culTime(minTime).substr(0, 11);
				if(minMisId == misId){
					document.title = tools.culTime(minTime).substr(3, 11)  + " - 解放农民" ;
				}
            }else{
                //独立线程启动
                (function(target){
					//判断该任务是否已经结束
					if(target.run){
						if(validate){
							document.getElementById("cropsState_" + target.owner.uId + "_" + target.farmIndex).innerHTML = "进行中...";
							job.onFarmRun(misId, target.owner, target.farm, target.farmIndex, 0);
						}else{
							document.getElementById("cropsState_" + target.owner.uId + "_" + target.farmIndex).innerHTML = "忽略";
							//更新单个数量
							document.getElementById("cropsCount_" + target.owner.uId + "_" + target.farmIndex).innerHTML = 0;
							//失败原因
							document.getElementById("cropsDirection_" + target.owner.uId + "_" + target.farmIndex).innerHTML = "等待输入验证码";
						}
					}
                })(mission);
				next = true;
            }
        } else {
            //自己的农田提前摘取时间设定
            if (mission.owner.uId == myId) {
                bTime = my_bTime;
            }
            if (minTime > bTime) {
                if(minTime > 0){
                	document.getElementById("cropsState_" + mission.owner.uId + "_" + mission.farmIndex).innerHTML = tools.culTime(minTime).substr(0, 11);
				}else if(minTime == 0){
					document.getElementById("cropsState_" + mission.owner.uId + "_" + mission.farmIndex).innerHTML = "00:00:00";
				}else{
					document.getElementById("cropsState_" + mission.owner.uId + "_" + mission.farmIndex).innerHTML = "-" + tools.culTime(Math.abs(minTime)).substr(3, 10);	
				}
            } else {
				//独立线程启动
                (function(target, job, time){
					//判断该任务是否已经结束
					if(mission.run){
						document.getElementById("cropsState_" + target.owner.uId + "_" + target.farmIndex).innerHTML = "进行中...";
						if(validate){
							window.setTimeout(function(){
								job.onFarmRun(misId, target.owner, target.farm, target.farmIndex, 0);
							}, (time - bTime) * 1000);
						}else{
							document.getElementById("cropsState_" + target.owner.uId + "_" + target.farmIndex).innerHTML = "忽略";
							//更新单个数量
							document.getElementById("cropsCount_" + target.owner.uId + "_" + target.farmIndex).innerHTML = 0;
							//失败原因
							document.getElementById("cropsDirection_" + target.owner.uId + "_" + target.farmIndex).innerHTML = "等待输入验证码";
						}
					}
                })(mission, job, minTime);
				next = true;
            }
        }
        //开始下一个任务
        if (next) {
            //当本次任务完成，终止此线程。
            window.clearInterval(interval[timer]);
            minMisId = minMisId + 1;
            maxMisId = maxMisId + 1;
            //开始下一线程
            (function(misId, timer, job, tools, appLoader){
                interval[timer] = window.setInterval(function(){
                    appLoader.getNextTime(misId, timer, job, tools, appLoader);
                }, 1000);
            })(maxMisId, timer, job, tools, appLoader);
        }
    };
    
    //更新进度条
    AppLoader_prototype.updateProgressBars = function(num, count){
        var progBar = document.getElementById("progMain");
        progBar.style.width = num / count * 100 + "%";
        progBar.innerHTML = Math.round(num / count * 100) + "%";
        document.title = "解放农民 - " + Math.round(num / count * 100) + "%完成";
        //window.scrollTo(0, document.body.scrollHeight);
    };
    
    //更新进度条
    AppLoader_prototype.updateProgressBar = function(num, count){
        var progBar = document.getElementById("progSub");
        progBar.style.width = num / count * 100 + "%";
        progBar.innerHTML = Math.round(num / count * 100) + "%";
    };
    
	//在商店列表中加入或去除一个种子
    AppLoader_prototype.cropsChoose = function(choose){
        for (var i = 0; i < cropsInfo.length; i++) {
            if (cropsInfo[i].cId == choose.id.substr(2, choose.id.length)) {
                cropsInfo[i]["check"] = choose.checked;
				break;
            }
        }
    };
	
    //在维护列表中加入或去除一个好友
    AppLoader_prototype.friendChoose = function(choose){
        for (var i = 0; i < userArray.length; i++) {
            if (userArray[i].uId == choose.id) {
                userArray[i]["check"] = choose.checked;
            }
        }
    };
    
    //在维护列表中选择全部好友
    AppLoader_prototype.friendChooseAll = function(){
        for (var i = 0; i < userArray.length; i++) {
            userArray[i]["check"] = true;
            document.getElementById(userArray[i].uId).checked = userArray[i]["check"];
        }
    };
    
    //在维护列表中反选全部好友
    AppLoader_prototype.friendChooseInversion = function(){
        for (var i = 0; i < userArray.length; i++) {
            if (userArray[i]["check"]) {
                userArray[i]["check"] = false;
            } else {
                userArray[i]["check"] = true;
            }
            document.getElementById(userArray[i].uId).checked = userArray[i]["check"];
        }
    };
    
    //在维护列表中自定义选择好友数
    AppLoader_prototype.friendChooseCustom = function(){
        var from = document.getElementById("friendChooseFrom").value;
        var to = document.getElementById("friendChooseTo").value;
        
        if (from == "") {
            from = 0;
        } else {
            if (isNaN(from)) {
                alert("开始序号请输入数字");
                return;
            } else if (from <= 0) {
                alert("开始序号应大于0");
                return;
            }
            from = from - 1;
        }
        
        if (to == "") {
            to = userArray.length;
        } else {
            if (isNaN(to)) {
                alert("结束序号请输入数字");
                return;
            } else if (to <= 0) {
                alert("结束序号应大于0");
                return;
            }
            to = to - 1;
        }
        
        if (from >= to) {
            alert("结束序号应大于开始序号！");
            return;
        }
        
        for (var i = 0; i < userArray.length; i++) {
            if (i >= from && i <= to) {
                userArray[i]["check"] = true;
            } else {
                userArray[i]["check"] = false;
            }
            document.getElementById(userArray[i].uId).checked = userArray[i]["check"];
        }
    };
    
    //增加一个种子
    AppLoader_prototype.addReadyCrops = function(cId, cName, type){
        var tmpCrops = new Array();
        tmpCrops.push(cId, cName, type);
        readyCrops.push(tmpCrops);
    };
    
    //升级版本检测
    AppLoader_prototype.checkUpgrade = function(){
        var tools = new happyfarm.util.Tools();
        tools.checkUpgrade();
    };
    
    //取得好友配置记录
    AppLoader_prototype.getfriendConfig = function(){
        var tools = new happyfarm.util.Tools();
        
        var fct = function(xmlDoc){
            var appLoader = new happyfarm.util.AppLoader();
            
            friendRecords = xmlDoc.getElementsByTagName("record");
            
            //在我的好友里生成列表
            for (var i = 0; i < userArray.length; i++) {
                appLoader.creatFriendList(i);
            }
        };
        tools.getConfig(myId + "\\friend.config", fct);
    };
	
	//取得选择偷菜配置记录
    AppLoader_prototype.getCropsConfig = function(){
        var tools = new happyfarm.util.Tools();
        
        var fct = function(xmlDoc){
            var appLoader = new happyfarm.util.AppLoader();
            
            cropsRecords = xmlDoc.getElementsByTagName("record");
            
            //生成种子选择列表
            for (var i = 0; i < cropsInfo.length; i++) {
				appLoader.creatCropsList(i);
			}
        };
        tools.getConfig(myId + "\\crops.config", fct);
    };
	
	//取得农田播种配置记录
    AppLoader_prototype.getFarmConfig = function(farms){
        var tools = new happyfarm.util.Tools();
        
        var fct = function(xmlDoc){
            var job = new happyfarm.util.Job();
            
            farmRecords = xmlDoc.getElementsByTagName("record");
			
            var myFarm = document.getElementById("farmland");
            //生成农田播种列表
            for (var i = 0; i < farms.length; i++) {
				job.createUserFarm(i, farms[i], myFarm);
			}
        };
        tools.getConfig(myId + "\\farm.config", fct);
    };
    
    //取得系统配置信息
    AppLoader_prototype.getSysConfig = function(){
        var tools = new happyfarm.util.Tools();
        
        var fct = function(xmlDoc){
            if (xmlDoc.getElementsByTagName("system").length > 0) {
                var param = new Array("weeds", "borers", "dryland", "crope", "time", "dog", "dogCrops1", "dogCrops2", "dogCrops3", "s-theft", "u-theft", "beforeTime", "myBeforeTime", "Anti-theft", "Auto-feed", "defult-crop", "defult-red-crop", "defult-crop-first", "Auto-fertilizer", "Auto-crops", "Auto-saleAll", "Auto-act", "Auto-farm", "retry", "ignoreCrops", "threadNum", "retryTime", "brushExpInterval", "harvestDetail", "farmDetail", "brushQQInterval", "alertSound", "alertSysSound", "intervalTimeCheck", "intervalTimeValue");
                for (var i = 0; i < param.length; i++) {
                    if (xmlDoc.getElementsByTagName(param[i])[0].getAttribute("value") == "true") {
                        document.getElementById(param[i]).checked = true;
                    } else if (xmlDoc.getElementsByTagName(param[i])[0].getAttribute("value") == "false") {
                        document.getElementById(param[i]).checked = false;
                    } else {
                        document.getElementById(param[i]).value = xmlDoc.getElementsByTagName(param[i])[0].getAttribute("value");
                    }
                }
            }
        };
        tools.getConfig(myId + "\\system.config", fct);
    };
    
    //保存好友配置
    AppLoader_prototype.saveFriendConfig = function(){
        var tools = new happyfarm.util.Tools();
        
        var content = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + "\n";
        content += "<friend>" + "\n";
        for (var i = 0; i < userArray.length; i++) {
            content += "<record userId=\"" + userArray[i].uId + "\" check=\"" + userArray[i].check + "\"/>" + "\n";
        }
        content += "</friend>";
        tools.saveConfig(content, "friend", null, true);
    };
	
	//保存种子配置
    AppLoader_prototype.saveCropsConfig = function(){
        var tools = new happyfarm.util.Tools();
        
        var content = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + "\n";
        content += "<crops>" + "\n";
        for (var i = 0; i < cropsInfo.length; i++) {
            content += "<record cId=\"" + cropsInfo[i].cId + "\" check=\"" + cropsInfo[i].check + "\"/>" + "\n";
        }
        content += "</crops>";
        tools.saveConfig(content, "crops", null, false);
    };
	
	//保存农田播种配置
    AppLoader_prototype.saveFarmConfig = function(){
        var tools = new happyfarm.util.Tools();
        
        var content = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + "\n";
        content += "<farm>" + "\n";
        for (var i = 0; i < 18; i++) {
			var farm = document.getElementById("farmContent"+i);
			if(farm){
				for(var j = 0;j<farm.childNodes.length;j++){
					content += "<record fId=\"" + i + "\" cId=\"" + farm.childNodes[j].id + "\" cName=\"" + farm.childNodes[j].innerHTML + "\"/>" + "\n";
				}
			}
        }
        content += "</farm>";
        tools.saveConfig(content, "farm", null, false);
    };
    
    //保存系统配置
    AppLoader_prototype.saveSysConfig = function(){
        var tools = new happyfarm.util.Tools();
        
        var content = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + "\n";
        content += "<system>" + "\n";
        content += "<weeds value=\"" + document.getElementById("weeds").checked + "\"/>" + "\n";
        content += "<borers value=\"" + document.getElementById("borers").checked + "\"/>" + "\n";
        content += "<dryland value=\"" + document.getElementById("dryland").checked + "\"/>" + "\n";
        content += "<crope value=\"" + document.getElementById("crope").checked + "\"/>" + "\n";
        content += "<time value=\"" + document.getElementById("time").value + "\"/>" + "\n";
        content += "<dog value=\"" + document.getElementById("dog").checked + "\"/>" + "\n";
		content += "<dogCrops1 value=\"" + document.getElementById("dogCrops1").value + "\"/>" + "\n";
		content += "<dogCrops2 value=\"" + document.getElementById("dogCrops2").value + "\"/>" + "\n";
		content += "<dogCrops3 value=\"" + document.getElementById("dogCrops3").value + "\"/>" + "\n";
        content += "<s-theft value=\"" + document.getElementById("s-theft").checked + "\"/>" + "\n";
        content += "<u-theft value=\"" + document.getElementById("u-theft").checked + "\"/>" + "\n";
        content += "<beforeTime value=\"" + document.getElementById("beforeTime").value + "\"/>" + "\n";
        content += "<myBeforeTime value=\"" + document.getElementById("myBeforeTime").value + "\"/>" + "\n";
        content += "<Anti-theft value=\"" + document.getElementById("Anti-theft").checked + "\"/>" + "\n";
        content += "<Auto-feed value=\"" + document.getElementById("Auto-feed").checked + "\"/>" + "\n";
        content += "<defult-crop value=\"" + document.getElementById("defult-crop").value + "\"/>" + "\n";
        content += "<defult-red-crop value=\"" + document.getElementById("defult-red-crop").value + "\"/>" + "\n";
		content += "<defult-crop-first value=\"" + document.getElementById("defult-crop-first").checked + "\"/>" + "\n";
        content += "<Auto-fertilizer value=\"" + document.getElementById("Auto-fertilizer").checked + "\"/>" + "\n";
        content += "<Auto-crops value=\"" + document.getElementById("Auto-crops").checked + "\"/>" + "\n";
        content += "<Auto-saleAll value=\"" + document.getElementById("Auto-saleAll").checked + "\"/>" + "\n";
        content += "<Auto-act value=\"" + document.getElementById("Auto-act").checked + "\"/>" + "\n";
		content += "<Auto-farm value=\"" + document.getElementById("Auto-farm").checked + "\"/>" + "\n";
        content += "<retry value=\"" + document.getElementById("retry").value + "\"/>" + "\n";
		content += "<ignoreCrops value=\"" + document.getElementById("ignoreCrops").checked + "\"/>" + "\n";
		content += "<threadNum value=\"" + document.getElementById("threadNum").value + "\"/>" + "\n";
		content += "<retryTime value=\"" + document.getElementById("retryTime").value + "\"/>" + "\n";
		content += "<brushExpInterval value=\"" + document.getElementById("brushExpInterval").value + "\"/>" + "\n";
		content += "<harvestDetail value=\"" + document.getElementById("harvestDetail").checked + "\"/>" + "\n";
		content += "<farmDetail value=\"" + document.getElementById("farmDetail").checked + "\"/>" + "\n";
		content += "<brushQQInterval value=\"" + document.getElementById("brushQQInterval").value + "\"/>" + "\n";
		content += "<alertSound value=\"" + document.getElementById("alertSound").checked + "\"/>" + "\n";
		content += "<alertSysSound value=\"" + document.getElementById("alertSysSound").value + "\"/>" + "\n";
		content += "<intervalTimeCheck value=\"" + document.getElementById("intervalTimeCheck").checked + "\"/>" + "\n";
		content += "<intervalTimeValue value=\"" + document.getElementById("intervalTimeValue").value + "\"/>" + "\n";
        content += "</system>";
        tools.saveConfig(content, "system", null, true);
		//保存种子配置
		this.saveCropsConfig();
		//保存农田播种信息
		this.saveFarmConfig();
    };
});

var appLoader = new happyfarm.util.AppLoader();
